/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.inventory.resource.CreateNewConfigurationChildResourceUIBean;
import org.rhq.enterprise.gui.inventory.resource.CreateNewPackageChildResourceUIBean;
import org.rhq.enterprise.gui.inventory.resource.ListChildResourcesUIBean;
import org.rhq.enterprise.gui.inventory.resource.UploadNewChildPackageUIBean;
import org.rhq.enterprise.gui.util.CustomEnglishPluralizer;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ListChildResourcesUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListChildResourcesUIBean";
    private static final String FORM_ID = "childResourcesForm";
    private static final String CHILD_TYPE_FILTER_INPUT_ID = "childTypeFilter";
    private static final String CHILD_TYPE_FILTER_INPUT_CLIENT_ID = "childResourcesForm:childTypeFilter";
    private static final String CHILD_TYPE_FILTER_VALUE_ALL = "ALL";
    private static final String NBSP = "&nbsp;";
    private static final String DEFAULT_RESOURCE_TYPE_ID = "SELECT_TYPE";
    private ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private String childTypeFilter;
    private List<ResourceType> utilizedChildServerTypes = this.resourceTypeManager.getUtilizedChildResourceTypesByCategory(EnterpriseFacesContextUtility.getSubject(), EnterpriseFacesContextUtility.getResource(), ResourceCategory.SERVER);
    private List<ResourceType> utilizedChildServiceTypes = this.resourceTypeManager.getUtilizedChildResourceTypesByCategory(EnterpriseFacesContextUtility.getSubject(), EnterpriseFacesContextUtility.getResource(), ResourceCategory.SERVICE);
    private int utilizedChildTypesCount = this.utilizedChildServerTypes.size() + this.utilizedChildServiceTypes.size();
    private List<ResourceType> childServerTypes = this.resourceTypeManager.getChildResourceTypesByCategory(EnterpriseFacesContextUtility.getSubject(), EnterpriseFacesContextUtility.getResource(), ResourceCategory.SERVER);
    private List<ResourceType> childServiceTypes = this.resourceTypeManager.getChildResourceTypesByCategory(EnterpriseFacesContextUtility.getSubject(), EnterpriseFacesContextUtility.getResource(), ResourceCategory.SERVICE);
    private int childTypesCount = this.childServerTypes.size() + this.childServiceTypes.size();
    private List<ResourceType> creatableChildServerTypes = this.getCreatableResourceTypes(this.childServerTypes);
    private List<ResourceType> creatableChildServiceTypes = this.getCreatableResourceTypes(this.childServiceTypes);
    private int creatableChildTypesCount = this.creatableChildServerTypes.size() + this.creatableChildServiceTypes.size();
    private List<ResourceType> manuallyAddableChildServerTypes = this.getManuallyAddableResourceTypes(this.childServerTypes);
    private List<ResourceType> manuallyAddableChildServiceTypes = this.getManuallyAddableResourceTypes(this.childServiceTypes);
    private int manuallyAddableChildTypesCount = this.manuallyAddableChildServerTypes.size() + this.manuallyAddableChildServiceTypes.size();
    private String manuallyAddResourceTypeId = "SELECT_TYPE";
    private String createNewResourceTypeId = "SELECT_TYPE";

    public String getClearStaleBeans() {
        try {
            FacesContextUtility.removeSessionScopedBean(CreateNewConfigurationChildResourceUIBean.class);
            FacesContextUtility.removeSessionScopedBean(CreateNewPackageChildResourceUIBean.class);
            FacesContextUtility.removeSessionScopedBean(UploadNewChildPackageUIBean.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public List<SelectItem> getUtilizedChildServerTypes() {
        List utilizedChildServerTypes = this.convertToSelectItems(this.utilizedChildServerTypes, true);
        if (!this.utilizedChildServerTypes.isEmpty()) {
            utilizedChildServerTypes.add(0, this.createSelectItemForResourceCategory(ResourceCategory.SERVER, false));
        }
        return utilizedChildServerTypes;
    }

    public List<SelectItem> getUtilizedChildServiceTypes() {
        List utilizedChildServiceTypes = this.convertToSelectItems(this.utilizedChildServiceTypes, true);
        if (!this.utilizedChildServiceTypes.isEmpty()) {
            utilizedChildServiceTypes.add(0, this.createSelectItemForResourceCategory(ResourceCategory.SERVICE, false));
        }
        return utilizedChildServiceTypes;
    }

    public int getUtilizedChildTypesCount() {
        return this.utilizedChildTypesCount;
    }

    public List<SelectItem> getChildServerTypes() {
        List childServerTypes = this.convertToSelectItems(this.childServerTypes, false);
        if (!this.childServerTypes.isEmpty()) {
            childServerTypes.add(0, this.createSelectItemForResourceCategory(ResourceCategory.SERVER, true));
        }
        return childServerTypes;
    }

    public List<SelectItem> getChildServiceTypes() {
        List childServiceTypes = this.convertToSelectItems(this.childServiceTypes, false);
        if (!this.childServiceTypes.isEmpty()) {
            childServiceTypes.add(0, this.createSelectItemForResourceCategory(ResourceCategory.SERVICE, true));
        }
        return childServiceTypes;
    }

    public int getChildTypesCount() {
        return this.childTypesCount;
    }

    public List<SelectItem> getCreatableChildServerTypes() {
        List creatableChildServerTypes = this.convertToSelectItems(this.creatableChildServerTypes, false);
        if (!this.creatableChildServerTypes.isEmpty()) {
            creatableChildServerTypes.add(0, this.createSelectItemForResourceCategory(ResourceCategory.SERVER, true));
        }
        return creatableChildServerTypes;
    }

    public List<SelectItem> getCreatableChildServiceTypes() {
        List creatableChildServiceTypes = this.convertToSelectItems(this.creatableChildServiceTypes, false);
        if (!this.creatableChildServiceTypes.isEmpty()) {
            creatableChildServiceTypes.add(0, this.createSelectItemForResourceCategory(ResourceCategory.SERVICE, true));
        }
        return creatableChildServiceTypes;
    }

    public List<SelectItem> getManuallyAddableChildServerTypes() {
        List manuallyAddableChildServerTypes = this.convertToSelectItems(this.manuallyAddableChildServerTypes, false);
        if (!this.manuallyAddableChildServerTypes.isEmpty()) {
            manuallyAddableChildServerTypes.add(0, this.createSelectItemForResourceCategory(ResourceCategory.SERVER, true));
        }
        return manuallyAddableChildServerTypes;
    }

    public List<SelectItem> getManuallyAddableChildServiceTypes() {
        List manuallyAddableChildServiceTypes = this.convertToSelectItems(this.manuallyAddableChildServiceTypes, false);
        if (!this.manuallyAddableChildServiceTypes.isEmpty()) {
            manuallyAddableChildServiceTypes.add(0, this.createSelectItemForResourceCategory(ResourceCategory.SERVICE, true));
        }
        return manuallyAddableChildServiceTypes;
    }

    public int getCreatableChildTypesCount() {
        return this.creatableChildTypesCount;
    }

    public int getManuallyAddableChildTypesCount() {
        return this.manuallyAddableChildTypesCount;
    }

    public String getChildTypeFilter() {
        return this.childTypeFilter;
    }

    public void setChildTypeFilter(String childTypeFilter) {
        this.childTypeFilter = childTypeFilter;
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListChildResourcesDataModel(this, PageControlView.ChildResourcesList, "ListChildResourcesUIBean");
        }
        return this.dataModel;
    }

    public String getManuallyAddResourceTypeId() {
        return this.manuallyAddResourceTypeId;
    }

    public void setManuallyAddResourceTypeId(String resourceTypeId) {
        this.manuallyAddResourceTypeId = resourceTypeId;
    }

    public String getCreateNewResourceTypeId() {
        return this.createNewResourceTypeId;
    }

    public void setCreateNewResourceTypeId(String resourceTypeId) {
        this.createNewResourceTypeId = resourceTypeId;
    }

    public void initChildTypeFilter() {
        if (this.childTypeFilter == null) {
            this.childTypeFilter = FacesContextUtility.getOptionalRequestParameter((String)"childResourcesForm:childTypeFilter");
        }
    }

    private List<ResourceType> getManuallyAddableResourceTypes(List<ResourceType> resourceTypes) {
        ArrayList<ResourceType> manuallyAddableResourceTypes = new ArrayList<ResourceType>();
        for (ResourceType resourceType : resourceTypes) {
            if (!resourceType.isSupportsManualAdd()) continue;
            manuallyAddableResourceTypes.add(resourceType);
        }
        return manuallyAddableResourceTypes;
    }

    private List<ResourceType> getCreatableResourceTypes(List<ResourceType> resourceTypes) {
        ArrayList<ResourceType> creatableResourceTypes = new ArrayList<ResourceType>();
        for (ResourceType resourceType : resourceTypes) {
            if (!resourceType.isCreatable()) continue;
            creatableResourceTypes.add(resourceType);
        }
        return creatableResourceTypes;
    }

    private SelectItem createSelectItemForResourceCategory(ResourceCategory resourceCategory, boolean disable) {
        SelectItem selectItem = new SelectItem((Object)resourceCategory.name(), resourceCategory.getDisplayName() + "s");
        selectItem.setDisabled(disable);
        return selectItem;
    }

    private List<SelectItem> convertToSelectItems(List<ResourceType> resourceTypes, boolean pluralize) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        CustomEnglishPluralizer customPluralizer = new CustomEnglishPluralizer();
        Set dupResourceTypeNames = ListChildResourcesUIBean.getDuplicateResourceTypeNames(resourceTypes);
        for (ResourceType resourceType : resourceTypes) {
            String label = "&nbsp; - " + (pluralize ? customPluralizer.pluralize(resourceType.getName()) : resourceType.getName());
            if (dupResourceTypeNames.contains(resourceType.getName())) {
                label = label + " (" + resourceType.getPlugin() + " plugin)";
            }
            SelectItem selectItem = new SelectItem((Object)resourceType.getId(), label);
            selectItem.setEscape(false);
            selectItems.add(selectItem);
        }
        return selectItems;
    }

    private static Set<String> getDuplicateResourceTypeNames(List<ResourceType> resourceTypes) {
        HashSet<String> resourceTypeNames = new HashSet<String>();
        HashSet<String> dupResourceTypeNames = new HashSet<String>();
        for (ResourceType resourceType : resourceTypes) {
            String resourceTypeName = resourceType.getName();
            if (resourceTypeNames.contains(resourceTypeName)) {
                dupResourceTypeNames.add(resourceTypeName);
            }
            resourceTypeNames.add(resourceTypeName);
        }
        return dupResourceTypeNames;
    }

    static /* synthetic */ String access$000(ListChildResourcesUIBean x0) {
        return x0.childTypeFilter;
    }

    static /* synthetic */ ResourceManagerLocal access$100(ListChildResourcesUIBean x0) {
        return x0.resourceManager;
    }

    static /* synthetic */ ResourceTypeManagerLocal access$200(ListChildResourcesUIBean x0) {
        return x0.resourceTypeManager;
    }
}

