/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.GenericValidator;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.legacy.action.resource.ResourceForm;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.ConditionBean;
import org.rhq.enterprise.gui.legacy.beans.OptionItem;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefinitionForm
extends ResourceForm {
    private Log log = LogFactory.getLog(DefinitionForm.class);
    private Integer ad;
    private String name;
    private String description;
    private int priority;
    private boolean active;
    private int recoverId;
    private String conditionExpression;
    private List<ConditionBean> conditions;
    private int metricId;
    private String metricName;
    private String consecutiveCountValue;
    private String partialCountValue;
    private String partialCountPeriod;
    private String inverseCountValue;
    private String durationCountValue;
    private String durationCountPeriod;
    private int durationCountPeriodUnits;
    private int whenEnabled;
    private boolean disableForRecovery;
    private boolean filteringControlActions;
    private boolean filteringNotificationActions;
    private Collection baselines;
    private List<MeasurementDefinition> metrics;
    private List<MeasurementDefinition> traits;
    private Collection<Map.Entry<String, Integer>> alertnames;
    private Collection<Map.Entry<String, String>> conditionExpressionNames;
    private boolean resourceConfigurationSupported;
    private boolean readOnly;
    private static String[] controlActionStatuses = new String[]{OperationRequestStatus.INPROGRESS.name(), OperationRequestStatus.SUCCESS.name(), OperationRequestStatus.FAILURE.name(), OperationRequestStatus.CANCELED.name()};
    private static String[] eventSeverities = new String[]{EventSeverity.DEBUG.name(), EventSeverity.INFO.name(), EventSeverity.WARN.name(), EventSeverity.ERROR.name(), EventSeverity.FATAL.name()};
    private static OptionItem[] availabilityOptions;
    private static int[] priorities;
    private static int[] timeUnits;
    private static String[] comparators;
    private boolean addingCondition;
    private int deletedCondition;

    public Integer getAd() {
        return this.ad;
    }

    public void setAd(Integer ad) {
        this.ad = ad;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getRecoverId() {
        return this.recoverId;
    }

    public void setRecoverId(int recoverId) {
        this.recoverId = recoverId;
    }

    public ConditionBean[] getConditions() {
        ConditionBean[] conds = new ConditionBean[this.conditions.size()];
        return this.conditions.toArray(conds);
    }

    public ConditionBean getCondition(int index) {
        if (index >= this.conditions.size()) {
            this.setNumConditions(index + 1);
        }
        return (ConditionBean)this.conditions.get(index);
    }

    public int getMetricId() {
        return this.metricId;
    }

    public void setMetricId(int metricId) {
        this.metricId = metricId;
        if (metricId > 0) {
            this.getCondition(0).setMetricId(Integer.valueOf(metricId));
            this.getCondition(0).setTrigger("onMeasurement");
        }
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
        this.getCondition(0).setMetricName(metricName);
    }

    public int getNumConditions() {
        return this.conditions.size();
    }

    public void setNumConditions(int numConditions) {
        while (this.conditions.size() < numConditions) {
            this.conditions.add(new ConditionBean());
        }
        while (this.conditions.size() > numConditions) {
            this.conditions.remove(this.conditions.size() - 1);
        }
    }

    public int getWhenEnabled() {
        return this.whenEnabled;
    }

    public void setWhenEnabled(int whenEnabled) {
        this.whenEnabled = whenEnabled;
    }

    public String getPartialCountValue() {
        return this.partialCountValue;
    }

    public void setPartialCountValue(String partialCountValue) {
        this.partialCountValue = partialCountValue;
    }

    public String getPartialCountPeriod() {
        return this.partialCountPeriod;
    }

    public void setPartialCountPeriod(String partialCountPeriod) {
        this.partialCountPeriod = partialCountPeriod;
    }

    public String getDurationCountValue() {
        return this.durationCountValue;
    }

    public void setDurationCountValue(String durationCountValue) {
        this.durationCountValue = durationCountValue;
    }

    public String getDurationCountPeriod() {
        return this.durationCountPeriod;
    }

    public void setDurationCountPeriod(String durationCountPeriod) {
        this.durationCountPeriod = durationCountPeriod;
    }

    public int getDurationCountPeriodUnits() {
        return this.durationCountPeriodUnits;
    }

    public void setDurationCountPeriodUnits(int durationCountPeriodUnits) {
        this.durationCountPeriodUnits = durationCountPeriodUnits;
    }

    public boolean isDisableForRecovery() {
        return this.disableForRecovery;
    }

    public void setDisableForRecovery(boolean disableForRecovery) {
        this.disableForRecovery = disableForRecovery;
    }

    public boolean isFilteringControlActions() {
        return this.filteringControlActions;
    }

    public void setFilteringControlActions(boolean filteringControlActions) {
        this.filteringControlActions = filteringControlActions;
    }

    public boolean isFilteringNotificationActions() {
        return this.filteringNotificationActions;
    }

    public void setFilteringNotificationActions(boolean filteringNotificationActions) {
        this.filteringNotificationActions = filteringNotificationActions;
    }

    public boolean isAddingCondition() {
        return this.addingCondition;
    }

    public void setAddingCondition(boolean addingCondition) {
        this.log.trace((Object)("setAddingCondition(" + addingCondition + ")"));
        this.addingCondition = addingCondition;
    }

    public int getDeletedCondition() {
        return this.deletedCondition;
    }

    public void setDeletedCondition(int deletedCondition) {
        this.log.trace((Object)("setDeletedCondition(" + deletedCondition + ")"));
        this.deletedCondition = deletedCondition;
    }

    public void deleteCondition(int deletedCondition) {
        if (deletedCondition < this.conditions.size()) {
            this.conditions.remove(deletedCondition);
        }
    }

    public Collection getBaselines() {
        return this.baselines;
    }

    public void setBaselines(Collection baselines) {
        this.baselines = baselines;
    }

    public List<MeasurementDefinition> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MeasurementDefinition> metrics) {
        this.metrics = metrics;
    }

    public List<MeasurementDefinition> getTraits() {
        return this.traits;
    }

    public void setTraits(List<MeasurementDefinition> traits) {
        this.traits = traits;
    }

    public Collection<Map.Entry<String, Integer>> getAlertnames() {
        return this.alertnames;
    }

    public void setAlertnames(Collection<Map.Entry<String, Integer>> alertnames) {
        this.alertnames = alertnames;
    }

    public String[] getControlActionStatuses() {
        return controlActionStatuses;
    }

    public String[] getEventSeverities() {
        return eventSeverities;
    }

    public OptionItem[] getAvailabilityOptions() {
        return availabilityOptions;
    }

    public int[] getPriorities() {
        return priorities;
    }

    public int[] getTimeUnits() {
        return timeUnits;
    }

    public String[] getComparators() {
        return comparators;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.setDefaults();
        try {
            Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
            PageList alertDefinitions = null;
            if (request.getParameter("id") != null && !request.getParameter("id").equals("")) {
                AlertDefinitionManagerLocal alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
                Integer resourceId = RequestUtils.getResourceId((HttpServletRequest)request);
                alertDefinitions = alertDefinitionManager.findAlertDefinitions(subject, resourceId.intValue(), PageControl.getUnlimitedInstance());
            } else if (request.getParameter("type") != null && !request.getParameter("type").equals("")) {
                AlertTemplateManagerLocal alertTemplateManager = LookupUtil.getAlertTemplateManager();
                Integer resourceTypeId = RequestUtils.getResourceTypeId((HttpServletRequest)request);
                alertDefinitions = alertTemplateManager.getAlertTemplates(subject, resourceTypeId.intValue(), PageControl.getUnlimitedInstance());
            } else {
                GroupAlertDefinitionManagerLocal groupAlertDefinitionManager = LookupUtil.getGroupAlertDefinitionManager();
                Integer groupId = RequestUtils.getGroupId((HttpServletRequest)request);
                alertDefinitions = groupAlertDefinitionManager.findGroupAlertDefinitions(subject, groupId.intValue(), PageControl.getUnlimitedInstance());
            }
            HashMap<String, Integer> alertDefinitionNameToIdMap = new HashMap<String, Integer>(alertDefinitions.size());
            for (AlertDefinition alertDefinition : alertDefinitions) {
                if (alertDefinition.getRecoveryId() != 0) continue;
                alertDefinitionNameToIdMap.put(alertDefinition.getName(), alertDefinition.getId());
            }
            this.setAlertnames(alertDefinitionNameToIdMap.entrySet());
        }
        catch (Exception e) {
            this.setAlertnames(new ArrayList(0));
        }
        HashMap<String, String> expressionsMap = new HashMap<String, String>();
        expressionsMap.put(BooleanExpression.ALL.toString(), BooleanExpression.ALL.name());
        expressionsMap.put(BooleanExpression.ANY.toString(), BooleanExpression.ANY.name());
        this.setConditionExpressionNames(expressionsMap.entrySet());
    }

    public void importProperties(AlertDefinition alertDef) {
        this.setAd(Integer.valueOf(alertDef.getId()));
        this.setName(alertDef.getName());
        this.setDescription(alertDef.getDescription());
        this.setActive(alertDef.getEnabled());
        this.setPriority(alertDef.getPriority().ordinal());
        this.setReadOnly(alertDef.isReadOnly());
    }

    public void exportProperties(AlertDefinition alertDef) {
        alertDef.setName(this.getName());
        alertDef.setDescription(this.getDescription());
        alertDef.setEnabled(this.isActive());
        alertDef.setPriority(AlertPriority.values()[this.getPriority()]);
        alertDef.setReadOnly(this.isReadOnly());
    }

    public void importConditionsEnablement(AlertDefinition alertDef, Subject subject) throws Exception {
        this.setAd(Integer.valueOf(alertDef.getId()));
        this.setConditionExpression(alertDef.getConditionExpression().name());
        Set conds = alertDef.getConditions();
        this.setNumConditions(conds.size());
        int i = 0;
        for (AlertCondition cond : conds) {
            ConditionBean condBean = (ConditionBean)this.conditions.get(i++);
            condBean.importProperties(cond, subject);
        }
        this.recoverId = alertDef.getRecoveryId();
        this.disableForRecovery = alertDef.getWillRecover();
        this.filteringControlActions = alertDef.getControlFiltered();
        this.filteringNotificationActions = alertDef.getNotifyFiltered();
        AlertDampening alertDampening = alertDef.getAlertDampening();
        AlertDampening.Category category = alertDampening.getCategory();
        if (AlertDampening.Category.CONSECUTIVE_COUNT == category) {
            this.consecutiveCountValue = String.valueOf(alertDampening.getValue());
        } else if (AlertDampening.Category.PARTIAL_COUNT == category) {
            this.partialCountPeriod = String.valueOf(alertDampening.getPeriod());
            this.partialCountValue = String.valueOf(alertDampening.getValue());
        } else if (AlertDampening.Category.INVERSE_COUNT == category) {
            this.inverseCountValue = String.valueOf(alertDampening.getValue());
        } else if (AlertDampening.Category.DURATION_COUNT == category) {
            this.durationCountValue = String.valueOf(alertDampening.getValue());
            this.durationCountPeriod = String.valueOf(alertDampening.getPeriod());
            this.durationCountPeriodUnits = alertDampening.getPeriodUnits().ordinal() + 1;
        }
        this.whenEnabled = alertDampening.getCategory().ordinal();
    }

    public void exportConditionsEnablement(AlertDefinition alertDef, HttpServletRequest request, Subject subject) throws Exception {
        alertDef.setConditionExpression(BooleanExpression.valueOf((String)this.getConditionExpression()));
        this.log.debug((Object)("Exporting " + this.getNumConditions() + " conditions..."));
        alertDef.removeAllConditions();
        for (int i = 0; i < this.getNumConditions(); ++i) {
            ConditionBean condBean = this.getCondition(i);
            AlertCondition newCondition = condBean.exportProperties(request, subject);
            alertDef.addCondition(newCondition);
        }
        alertDef.setRecoveryId(Integer.valueOf(this.getRecoverId()));
        alertDef.setWillRecover(this.isDisableForRecovery());
        alertDef.setNotifyFiltered(this.isFilteringNotificationActions());
        alertDef.setControlFiltered(this.isFilteringControlActions());
        AlertDampening alertDampening = new AlertDampening(AlertDampening.Category.values()[this.getWhenEnabled()]);
        alertDef.setAlertDampening(alertDampening);
        AlertDampening.Category category = alertDampening.getCategory();
        if (category == AlertDampening.Category.CONSECUTIVE_COUNT) {
            alertDampening.setValue(Integer.valueOf(this.getConsecutiveCountValue()).intValue());
        } else if (category == AlertDampening.Category.PARTIAL_COUNT) {
            alertDampening.setValue(Integer.valueOf(this.getPartialCountValue()).intValue());
            alertDampening.setPeriod(Integer.valueOf(this.getPartialCountPeriod()).intValue());
        } else if (category == AlertDampening.Category.INVERSE_COUNT) {
            alertDampening.setValue(Integer.valueOf(this.getInverseCountValue()).intValue());
        } else if (alertDampening.getCategory() == AlertDampening.Category.DURATION_COUNT) {
            alertDampening.setValue(Integer.valueOf(this.getDurationCountValue()).intValue());
            alertDampening.setPeriod(Integer.valueOf(this.getDurationCountPeriod()).intValue());
            alertDampening.setPeriodUnits(AlertDampening.TimeUnits.values()[this.getDurationCountPeriodUnits() - 1]);
        }
    }

    public void resetConditions() {
        this.conditions = new ArrayList();
        this.setNumConditions(1);
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        if (!this.shouldValidate(mapping, request)) {
            return null;
        }
        ActionErrors errs = super.validate(mapping, request);
        if (null == errs) {
            errs = new ActionErrors();
        }
        if (mapping.getName().equals("NewAlertDefinitionForm") || mapping.getName().equals("EditAlertDefinitionConditionsForm")) {
            for (int i = 0; i < this.getNumConditions(); ++i) {
                ConditionBean cond = this.getCondition(i);
                cond.validate(request, errs, i);
            }
            AlertDampening.Category selectedCategory = AlertDampening.Category.values()[this.getWhenEnabled()];
            if (selectedCategory == AlertDampening.Category.CONSECUTIVE_COUNT) {
                this.validatePositive(this.getConsecutiveCountValue(), "consecutiveCountValue", errs);
            } else if (selectedCategory == AlertDampening.Category.PARTIAL_COUNT) {
                if (this.validatePositive(this.getPartialCountValue(), "partialCountValue", errs) && this.validatePositive(this.getPartialCountPeriod(), "partialCountPeriod", errs) && Integer.parseInt(this.getPartialCountValue()) > Integer.parseInt(this.getPartialCountPeriod())) {
                    errs.add("partialCountPeriod", new ActionMessage("alert.config.error.PartialCountRangeTooSmall"));
                }
            } else if (selectedCategory == AlertDampening.Category.INVERSE_COUNT) {
                this.validatePositive(this.getInverseCountValue(), "inverseCountValue", errs);
            } else if (selectedCategory == AlertDampening.Category.DURATION_COUNT) {
                boolean valid = this.validatePositive(this.getDurationCountValue(), "durationCountValue", errs) && this.validatePositive(this.getDurationCountPeriod(), "durationCountPeriod", errs);
            }
        }
        return errs;
    }

    private boolean validatePositive(String field, String fieldName, ActionErrors errs) {
        if (GenericValidator.isBlankOrNull((String)field)) {
            errs.add(fieldName, new ActionMessage("alert.config.error.DampeningFieldRequired"));
            return false;
        }
        if (!GenericValidator.isInt((String)field) || Integer.parseInt(field) < 1) {
            errs.add(fieldName, new ActionMessage("alert.config.error.InvalidDampeningField"));
            return false;
        }
        return true;
    }

    private void setDefaults() {
        this.ad = null;
        this.name = null;
        this.description = null;
        this.priority = AlertPriority.MEDIUM.ordinal();
        this.active = true;
        this.resetConditions();
        this.conditionExpression = BooleanExpression.ALL.name();
        this.whenEnabled = AlertDampening.Category.NONE.ordinal();
        this.consecutiveCountValue = null;
        this.partialCountValue = null;
        this.partialCountPeriod = null;
        this.inverseCountValue = null;
        this.durationCountValue = null;
        this.durationCountPeriod = null;
        this.durationCountPeriodUnits = AlertDampening.TimeUnits.MINUTES.ordinal() + 1;
        this.filteringControlActions = false;
        this.filteringNotificationActions = false;
        this.addingCondition = false;
        this.deletedCondition = -1;
        this.baselines = null;
    }

    public void setAvailabilityActions(List<OptionItem> availabilityActions) {
    }

    public String getConditionExpression() {
        return this.conditionExpression;
    }

    public void setConditionExpression(String conditionExpression) {
        this.conditionExpression = conditionExpression;
    }

    public Collection<Map.Entry<String, String>> getConditionExpressionNames() {
        return this.conditionExpressionNames;
    }

    public void setConditionExpressionNames(Collection<Map.Entry<String, String>> conditionExpressionNames) {
        this.conditionExpressionNames = conditionExpressionNames;
    }

    public boolean isResourceConfigurationSupported() {
        return this.resourceConfigurationSupported;
    }

    public void setResourceConfigurationSupported(boolean resourceConfigurationSupported) {
        this.resourceConfigurationSupported = resourceConfigurationSupported;
    }

    public String getConsecutiveCountValue() {
        return this.consecutiveCountValue;
    }

    public void setConsecutiveCountValue(String consecutiveTimes) {
        this.consecutiveCountValue = consecutiveTimes;
    }

    public String getInverseCountValue() {
        return this.inverseCountValue;
    }

    public void setInverseCountValue(String inverseCountValue) {
        this.inverseCountValue = inverseCountValue;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    static {
        AvailabilityType[] values = AvailabilityType.values();
        availabilityOptions = new OptionItem[values.length];
        for (int i = 0; i < availabilityOptions.length; ++i) {
            DefinitionForm.availabilityOptions[i] = new OptionItem("Goes " + values[i].name(), values[i].name());
        }
        priorities = new int[]{AlertPriority.HIGH.ordinal(), AlertPriority.MEDIUM.ordinal(), AlertPriority.LOW.ordinal()};
        timeUnits = new int[]{1, 2, 3, 4};
        comparators = new String[]{">", "=", "<"};
    }
}

