/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.group.inventory;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.resource.group.inventory.GroupForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupUpdateException;
import org.rhq.enterprise.server.util.LookupUtil;

public class EditGeneralAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog(EditGeneralAction.class);
        GroupForm groupForm = (GroupForm)form;
        Integer groupId = groupForm.getGroupId();
        String category = groupForm.getCategory();
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        HashMap<String, Object> forwardParams = new HashMap<String, Object>(2);
        forwardParams.put("groupId", groupId);
        forwardParams.put("category", category);
        ActionForward forward = this.checkSubmit(request, mapping, form, forwardParams, true);
        if (forward != null) {
            return forward;
        }
        try {
            ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
            ResourceGroup group = groupManager.getResourceGroupById(subject, groupId.intValue(), null);
            groupForm.updateResourceGroup(group);
            groupManager.updateResourceGroup(subject, group);
            log.trace((Object)("saving group [" + group.getName() + "]" + " with attributes " + groupForm));
            RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.group.inventory.confirm.EditGeneralProperties");
            return this.returnSuccess(request, mapping, forwardParams, true);
        }
        catch (ResourceGroupUpdateException rgue) {
            log.debug((Object)"group update failed:", (Throwable)rgue);
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.group.inventory.error.GroupUpdateError", (String)rgue.getMessage());
            return this.returnFailure(request, mapping, forwardParams);
        }
    }
}

