/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.portlet.criticalalerts;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.rhq.core.clientapi.util.units.DateFormatter;
import org.rhq.core.clientapi.util.units.FormatSpecifics;
import org.rhq.core.clientapi.util.units.FormattedNumber;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;
import org.rhq.core.clientapi.util.units.UnitsFormat;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.portlet.BaseRSSAction;
import org.rhq.enterprise.gui.legacy.portlet.RSSFeed;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RSSAction
extends BaseRSSAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RSSFeed feed = this.getNewRSSFeed(request);
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        MessageResources res = this.getResources(request);
        feed.setTitle(res.getMessage("dash.home.CriticalAlerts"));
        WebUser user = this.getWebUser(request);
        if (user != null) {
            WebUserPreferences.AlertsPortletPreferences prefs = user.getWebPreferences().getAlertsPortletPreferences();
            PageControl pageControl = new PageControl(0, prefs.count);
            PageList alerts = alertManager.findAlerts(user.getSubject(), "all".equals(prefs.displayAll) ? null : ArrayUtils.wrapInArray((int[])prefs.asArray()), AlertPriority.getByLegacyIndex((int)prefs.priority), prefs.timeRange, pageControl);
            if (alerts != null && alerts.size() > 0) {
                for (Alert alert : alerts) {
                    String link = feed.getBaseUrl() + "/alerts/Alerts.do?mode=viewAlert&id=" + alert.getAlertDefinition().getResource().getId() + "&a=" + alert.getId();
                    DateFormatter.DateSpecifics specs = new DateFormatter.DateSpecifics();
                    specs.setDateFormat((DateFormat)new SimpleDateFormat(res.getMessage("unit.format.epoch-millis")));
                    FormattedNumber fmtd = UnitsFormat.format((UnitNumber)new UnitNumber((double)alert.getCtime(), UnitsConstants.UNIT_DATE, ScaleConstants.SCALE_MILLI), (Locale)request.getLocale(), (FormatSpecifics)specs);
                    feed.addItem(alert.getAlertDefinition().getResource().getName() + " " + alert.getAlertDefinition().getName(), link, fmtd.toString(), alert.getCtime());
                }
            }
            request.setAttribute("rssFeed", (Object)feed);
            return mapping.findForward("rss.feed");
        }
        throw new LoginException("RSS access requires authentication");
    }
}

