/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.beans.ReturnPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SessionUtils {
    private static final Log log = LogFactory.getLog(SessionUtils.class);
    private static final int RETURN_STACK_MAX_SIZE = 128;

    public static WebUser getWebUser(HttpSession session) {
        if (session == null) {
            return null;
        }
        Object attr = session.getAttribute("webUser");
        if (attr == null) {
            return null;
        }
        WebUser user = (WebUser)attr;
        log.debug((Object)"Loading WebUser");
        return user;
    }

    public static void setWebUser(HttpSession session, WebUser user) {
        if (user == null) {
            session.removeAttribute("webUser");
        } else {
            session.setAttribute("webUser", (Object)user);
        }
    }

    public static Integer[] getList(HttpSession session, String attr) {
        Object list = session.getAttribute(attr);
        Integer[] pendingIds = null;
        try {
            pendingIds = (Integer[])list;
        }
        catch (ClassCastException e) {
            List pendingIdsList = (List)list;
            pendingIds = pendingIdsList.toArray(new Integer[pendingIdsList.size()]);
        }
        if (pendingIds == null) {
            pendingIds = new Integer[]{};
        }
        return pendingIds;
    }

    public static List getListAsList(HttpSession session, String attr) {
        Object list = session.getAttribute(attr);
        List<Integer> pendingIds = null;
        try {
            pendingIds = (List<Integer>)list;
        }
        catch (ClassCastException e) {
            Integer[] pendingIdsArray = (Integer[])list;
            pendingIds = Arrays.asList(pendingIdsArray);
        }
        if (pendingIds == null) {
            pendingIds = new ArrayList<Integer>();
        }
        return pendingIds;
    }

    public static List<String> getListAsListStr(HttpSession session, String attr) {
        Object list = session.getAttribute(attr);
        List<String> pendingIds = null;
        try {
            pendingIds = (List<String>)list;
        }
        catch (ClassCastException e) {
            String[] pendingIdsArray = (String[])list;
            pendingIds = Arrays.asList(pendingIdsArray);
        }
        if (pendingIds == null) {
            pendingIds = new ArrayList<String>();
        }
        return pendingIds;
    }

    public static void addToList(HttpSession session, String attr, List ids) {
        ArrayList pendingIds = (ArrayList)session.getAttribute(attr);
        if (pendingIds == null) {
            pendingIds = new ArrayList();
        }
        session.setAttribute(attr, (Object)SessionUtils.mergeIds(pendingIds, (List)ids));
    }

    public static void addToList(HttpSession session, String attr, Integer[] ids) {
        SessionUtils.addToList((HttpSession)session, (String)attr, Arrays.asList(ids));
    }

    public static void addToListStr(HttpSession session, String attr, List ids) {
        ArrayList pendingIds = (ArrayList)session.getAttribute(attr);
        if (pendingIds == null) {
            pendingIds = new ArrayList();
        }
        session.setAttribute(attr, (Object)SessionUtils.mergeStrIds(pendingIds, (List)ids));
    }

    public static void addToList(HttpSession session, String attr, String[] ids) {
        SessionUtils.addToListStr((HttpSession)session, (String)attr, Arrays.asList(ids));
    }

    public static void removeFromList(HttpSession session, String attr, List ids) {
        ArrayList pendingIds = (ArrayList)session.getAttribute(attr);
        if (pendingIds == null) {
            pendingIds = new ArrayList();
        }
        session.setAttribute(attr, (Object)SessionUtils.grepIds(pendingIds, (List)ids));
    }

    public static void removeFromList(HttpSession session, String attr, Integer[] ids) {
        SessionUtils.removeFromList((HttpSession)session, (String)attr, Arrays.asList(ids));
    }

    public static void removeFromListStr(HttpSession session, String attr, List ids) {
        ArrayList pendingIds = (ArrayList)session.getAttribute(attr);
        if (pendingIds == null) {
            pendingIds = new ArrayList();
        }
        session.setAttribute(attr, (Object)SessionUtils.grepStrIds(pendingIds, (List)ids));
    }

    public static void removeFromList(HttpSession session, String attr, String[] ids) {
        SessionUtils.removeFromListStr((HttpSession)session, (String)attr, Arrays.asList(ids));
    }

    public static void removeList(HttpSession session, String attr) {
        session.removeAttribute(attr);
    }

    public static String getReturnPath(HttpSession session) {
        LinkedList stack = (LinkedList)session.getAttribute("returnLoc");
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        ReturnPath returnPath = (ReturnPath)stack.getFirst();
        return returnPath.getPath();
    }

    public static void setReturnPath(HttpSession session, String path) {
        SessionUtils.setReturnPath((HttpSession)session, (String)path, (Boolean)Boolean.FALSE);
    }

    public static void setReturnPath(HttpSession session, String path, Boolean ignore) {
        LinkedList<ReturnPath> stack = (LinkedList<ReturnPath>)session.getAttribute("returnLoc");
        ReturnPath returnPath = new ReturnPath();
        if (stack == null) {
            stack = new LinkedList<ReturnPath>();
        }
        returnPath.setPath(path);
        returnPath.setIgnore(ignore);
        stack.addFirst(returnPath);
        if (stack.size() > 128) {
            stack.removeLast();
        }
        session.setAttribute("returnLoc", stack);
    }

    public static void resetReturnPath(HttpSession session) {
        LinkedList stack = new LinkedList();
        session.setAttribute("returnLoc", stack);
    }

    public static void unsetReturnPath(HttpSession session) {
        LinkedList retstack = (LinkedList)session.getAttribute("returnLoc");
        if (retstack != null && retstack.size() >= 1) {
            retstack.removeFirst();
        }
    }

    public static Boolean getReturnPathIgnoredForOk(HttpSession session) {
        LinkedList stack = (LinkedList)session.getAttribute("returnLoc");
        if (stack == null || stack.isEmpty()) {
            return Boolean.FALSE;
        }
        ReturnPath returnPath = (ReturnPath)stack.getFirst();
        if (returnPath == null) {
            return Boolean.FALSE;
        }
        return returnPath.getIgnore();
    }

    public static void unsetReturnPathIgnoredForOk(HttpSession session) {
        LinkedList stack = (LinkedList)session.getAttribute("returnLoc");
        ReturnPath returnPath = (ReturnPath)stack.getFirst();
        returnPath.setIgnore(Boolean.TRUE);
    }

    public static void clearWorkflow(HttpSession session, String workflowName) {
        HashMap workflows = (HashMap)session.getAttribute("workflowSesAttr");
        if (workflows != null) {
            workflows.remove(workflowName);
        }
    }

    public static void pushWorkflow(HttpSession session, ActionMapping mapping, String workflowName) {
        LinkedList<String> urlStack;
        String returnPath;
        HashMap<String, LinkedList<String>> workflows = (HashMap<String, LinkedList<String>>)session.getAttribute("workflowSesAttr");
        if (workflows == null) {
            workflows = new HashMap<String, LinkedList<String>>();
        }
        if ((returnPath = SessionUtils.getReturnPath((HttpSession)session)) == null) {
            returnPath = mapping.getInput();
        }
        if ((urlStack = (LinkedList<String>)workflows.get(workflowName)) == null) {
            urlStack = new LinkedList<String>();
        }
        urlStack.addLast(returnPath);
        workflows.put(workflowName, urlStack);
        session.setAttribute("workflowSesAttr", workflows);
    }

    public static String popWorkflow(HttpSession session, String workflowName) {
        HashMap workflows = (HashMap)session.getAttribute("workflowSesAttr");
        if (workflows == null) {
            return null;
        }
        LinkedList urlStack = (LinkedList)workflows.get(workflowName);
        if (urlStack == null || urlStack.isEmpty()) {
            return null;
        }
        String returnUrl = (String)urlStack.removeLast();
        workflows.put(workflowName, urlStack);
        session.setAttribute("workflowSesAttr", (Object)workflows);
        return returnUrl;
    }

    public static int countWorkflow(HttpSession session, String workflowName) {
        HashMap workflows = (HashMap)session.getAttribute("workflowSesAttr");
        if (workflows == null) {
            return 0;
        }
        LinkedList urlStack = (LinkedList)workflows.get(workflowName);
        if (urlStack == null || urlStack.isEmpty()) {
            return 0;
        }
        return urlStack.size();
    }

    private static List grepIds(List all, List matches) {
        if (all == null || matches == null) {
            return new ArrayList();
        }
        HashSet index = new HashSet();
        Iterator mi = matches.iterator();
        while (mi.hasNext()) {
            index.add(mi.next());
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Integer id : all) {
            if (index.contains(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    private static List grepStrIds(List pending, List newItems) {
        if (pending == null || newItems == null) {
            return new ArrayList();
        }
        HashSet index = new HashSet();
        Iterator mi = newItems.iterator();
        while (mi.hasNext()) {
            index.add(mi.next());
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : pending) {
            if (index.contains(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    private static List mergeIds(List orig, List added) {
        if (orig == null && added == null) {
            return new ArrayList();
        }
        if (orig == null) {
            return added;
        }
        if (added == null) {
            return orig;
        }
        ArrayList ids = new ArrayList();
        HashSet index = new HashSet();
        for (Object next : orig) {
            index.add(next);
            ids.add(next);
        }
        for (Integer id : added) {
            if (index.contains(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    private static List mergeStrIds(List orig, List added) {
        if (orig == null && added == null) {
            return new ArrayList();
        }
        if (orig == null) {
            return added;
        }
        if (added == null) {
            return orig;
        }
        ArrayList ids = new ArrayList();
        HashSet index = new HashSet();
        for (Object next : orig) {
            index.add(next);
            ids.add(next);
        }
        for (String id : added) {
            if (index.contains(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    public static void setConfirmation(HttpSession session, String key) {
        ActionMessage msg = new ActionMessage(key);
        ActionMessages msgs = new ActionMessages();
        msgs.add("org.apache.struts.action.GLOBAL_MESSAGE", msg);
        if (session != null) {
            session.setAttribute("org.apache.struts.action.ACTION_MESSAGE", (Object)msgs);
        }
    }

    public static void setConfirmation(HttpSession session, String key, Object value0) {
        ActionMessage msg = new ActionMessage(key, value0);
        ActionMessages msgs = new ActionMessages();
        msgs.add("org.apache.struts.action.GLOBAL_MESSAGE", msg);
        if (session != null) {
            session.setAttribute("org.apache.struts.action.ACTION_MESSAGE", (Object)msgs);
        }
    }

    public static void unsetConfirmation(HttpSession session, String key) {
        session.removeAttribute("org.apache.struts.action.ACTION_MESSAGE");
    }

    public static void setError(HttpSession session, String key) {
        SessionUtils.setError((HttpSession)session, (String)key, (String)"org.apache.struts.action.GLOBAL_MESSAGE");
    }

    public static void setError(HttpSession session, String key, String property) {
        ActionMessage err = new ActionMessage(key);
        ActionErrors errs = new ActionErrors();
        errs.add(property, err);
        if (session != null) {
            session.setAttribute("org.apache.struts.action.ERROR", (Object)errs);
        }
    }

    public static void setError(HttpSession session, String key, Object value0) {
        SessionUtils.setError((HttpSession)session, (String)key, (Object)value0, (String)"org.apache.struts.action.GLOBAL_MESSAGE");
    }

    public static void setError(HttpSession session, String key, Object value0, String property) {
        ActionMessage err = new ActionMessage(key, value0);
        ActionErrors errs = new ActionErrors();
        errs.add(property, err);
        if (session != null) {
            session.setAttribute("org.apache.struts.action.ERROR", (Object)errs);
        }
    }

    public static void unsetError(HttpSession session) {
        if (session != null) {
            session.removeAttribute("org.apache.struts.action.ERROR");
        }
    }

    public static void moveAttribute(HttpServletRequest request, String key) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            request.setAttribute(key, session.getAttribute(key));
            session.removeAttribute(key);
        }
    }
}

