/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.resource.group.composite.AutoGroupComposite;
import org.rhq.core.util.sort.HumaneStringComparator;
import org.rhq.enterprise.gui.navigation.resource.ResourceTreeNode;
import org.rhq.enterprise.server.resource.cluster.ClusterKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupTreeNode
implements Comparable<ResourceGroupTreeNode> {
    private final Log log = LogFactory.getLog(ResourceGroupTreeNode.class);
    private static ResourceGroupTreeNode[] CHILDREN_ABSENT = new ResourceGroupTreeNode[0];
    private ClusterKey clusterKey;
    private TreeSet<ResourceGroupTreeNode> children = new TreeSet();
    private List<ResourceTreeNode> members = new ArrayList();
    private Object level;
    private String shortPath;

    public ResourceGroupTreeNode(Object level) {
        this.level = level;
    }

    public ClusterKey getClusterKey() {
        return this.clusterKey;
    }

    public void setClusterKey(ClusterKey clusterKey) {
        this.clusterKey = clusterKey;
    }

    public void addMembers(Set<ResourceTreeNode> members) {
        this.members.addAll(members);
    }

    public void addMember(ResourceTreeNode member) {
        this.members.add(member);
    }

    public TreeSet<ResourceGroupTreeNode> getChildren() {
        return this.children;
    }

    public List<ResourceTreeNode> getMembers() {
        return this.members;
    }

    public synchronized TreeSet<ResourceGroupTreeNode> getNodes() {
        return this.children;
    }

    public Object getData() {
        return this.level;
    }

    public String toString() {
        if (this.level instanceof ResourceGroup) {
            ResourceGroup group = (ResourceGroup)this.level;
            return group.getName();
        }
        if (this.level instanceof AutoGroupComposite) {
            AutoGroupComposite ag = (AutoGroupComposite)this.level;
            if (ag.getResourceType() != null) {
                return ag.getResourceType().getName();
            }
            if (ag.getSubcategory() != null) {
                return ag.getSubcategory().getName();
            }
        }
        return this.level.toString();
    }

    @Override
    public int compareTo(ResourceGroupTreeNode that) {
        try {
            return HumaneStringComparator.DEFAULT.compare(this.toString(), that.toString());
        }
        catch (Exception e) {
            this.log.warn((Object)("Couldn't compare: " + this.toString() + " || " + that + " - cause: " + e));
            return this.toString().compareTo(that.toString());
        }
    }

    public void addChildren(Collection<ResourceGroupTreeNode> resourceGroupTreeNodes) {
        this.children.addAll(resourceGroupTreeNodes);
    }
}

