/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.group;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.resource.group.composite.AutoGroupComposite;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.navigation.group.ResourceGroupTreeNode;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.cluster.ClusterKey;
import org.rhq.enterprise.server.resource.cluster.ClusterManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.component.UITree;
import org.richfaces.component.html.HtmlTree;
import org.richfaces.component.state.TreeState;
import org.richfaces.component.state.TreeStateAdvisor;
import org.richfaces.event.NodeSelectedEvent;
import org.richfaces.model.TreeRowKey;

public class ResourceGroupTreeStateAdvisor
implements TreeStateAdvisor {
    private Integer selectedId;
    private TreeRowKey selectedKey;
    private ClusterKey selectedClusterKey;
    private ResourceGroup currentGroup;

    public ResourceGroup getCurrentGroup() {
        if (this.currentGroup == null || this.currentGroup.getId() != this.getSelectedGroupId()) {
            this.selectedId = this.getSelectedGroupId();
            ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
            this.currentGroup = groupManager.getResourceGroupById(EnterpriseFacesContextUtility.getSubject(), this.selectedId.intValue(), null);
            if (!this.currentGroup.isVisible()) {
                this.selectedClusterKey = ClusterKey.valueOf((String)this.currentGroup.getClusterKey());
            }
        }
        return this.currentGroup;
    }

    private int getSelectedGroupId() {
        String groupId = FacesContextUtility.getOptionalRequestParameter((String)"groupId");
        return Integer.parseInt(groupId);
    }

    public Boolean adviseNodeOpened(UITree tree) {
        TreeRowKey key = (TreeRowKey)tree.getRowKey();
        if (key != null) {
            TreeState state = (TreeState)tree.getComponentState();
            TreeRowKey selectedKey = state.getSelectedNode();
            this.getCurrentGroup();
            if (this.preopen((ResourceGroupTreeNode)tree.getRowData((Object)key), this.selectedId.intValue())) {
                return true;
            }
        }
        return null;
    }

    private boolean preopen(ResourceGroupTreeNode resourceTreeNode, int selectedGroupId) {
        ResourceGroup currentGroup = this.getCurrentGroup();
        if (resourceTreeNode.getData() instanceof ClusterKey) {
            if (((ClusterKey)resourceTreeNode.getData()).equals((Object)this.selectedClusterKey)) {
                return true;
            }
        } else if (resourceTreeNode.getData() instanceof AutoGroupComposite) {
            ClusterKey key = resourceTreeNode.getClusterKey();
            AutoGroupComposite ag = (AutoGroupComposite)resourceTreeNode.getData();
            if (key.equals((Object)this.selectedClusterKey)) {
                return true;
            }
        } else if (resourceTreeNode.getData() instanceof ResourceGroup && currentGroup.getId() == ((ResourceGroup)resourceTreeNode.getData()).getId()) {
            return true;
        }
        for (ResourceGroupTreeNode child : resourceTreeNode.getChildren()) {
            if (!this.preopen(child, selectedGroupId)) continue;
            return true;
        }
        return false;
    }

    public void nodeSelectListener(NodeSelectedEvent e) {
        HtmlTree tree = (HtmlTree)e.getComponent();
        TreeState state = (TreeState)tree.getComponentState();
        try {
            tree.queueNodeExpand((TreeRowKey)tree.getRowKey());
            ResourceGroupTreeNode node = (ResourceGroupTreeNode)tree.getRowData(tree.getRowKey());
            if (node != null) {
                ServletContext context = (ServletContext)FacesContextUtility.getFacesContext().getExternalContext().getContext();
                HttpServletResponse response = (HttpServletResponse)FacesContextUtility.getFacesContext().getExternalContext().getResponse();
                Subject subject = EnterpriseFacesContextUtility.getSubject();
                if (node.getData() instanceof ClusterKey) {
                    ClusterManagerLocal clusterManager = LookupUtil.getClusterManager();
                    ResourceGroup group = clusterManager.createAutoClusterBackingGroup(subject, (ClusterKey)node.getData(), true);
                    String path = "/rhq/group/inventory/view.xhtml";
                    response.sendRedirect(path + "?groupId=" + group.getId() + "&parentGroupId=" + ((ClusterKey)node.getData()).getClusterGroupId());
                } else if (node.getData() instanceof AutoGroupComposite) {
                    state.setSelected(e.getOldSelection());
                    FacesContext.getCurrentInstance().addMessage("leftNavGroupTreeForm:leftNavGroupTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "No cluster autogroup views available", null));
                } else if (node.getData() instanceof ResourceGroup) {
                    String path = "/rhq/group/inventory/view.xhtml";
                    response.sendRedirect(path + "?groupId=" + ((ResourceGroup)node.getData()).getId());
                }
            }
        }
        catch (Exception e1) {
            state.setSelected(e.getOldSelection());
            FacesContext.getCurrentInstance().addMessage("leftNavGroupTreeForm:leftNavGroupTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "Unable to browse to selected group view: " + e1.getMessage(), null));
            e1.printStackTrace();
        }
    }

    public Boolean adviseNodeSelected(UITree tree) {
        ResourceGroup currentGroup = this.getCurrentGroup();
        ResourceGroupTreeNode node = (ResourceGroupTreeNode)tree.getRowData(tree.getRowKey());
        if (node.getData() instanceof ResourceGroup) {
            return this.selectedId.intValue() == ((ResourceGroup)node.getData()).getId();
        }
        if (node.getData() instanceof ClusterKey) {
            ClusterKey key = (ClusterKey)node.getData();
            if (currentGroup.getClusterKey() != null && currentGroup.getClusterKey().equals(key.getKey())) {
                return true;
            }
        }
        return false;
    }
}

