/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.LockedResource;
import org.rhq.core.domain.resource.group.composite.AutoGroupComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.navigation.resource.ResourceTreeNode;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.HibernatePerformanceMonitor;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ResourceTreeModelUIBean {
    private static final Log log = LogFactory.getLog(ResourceTreeModelUIBean.class);
    private List<ResourceTreeNode> roots = new ArrayList();
    private ResourceTreeNode rootNode = null;
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private AgentManagerLocal agentManager = LookupUtil.getAgentManager();
    private String nodeTitle;

    private void loadTree() {
        Resource currentResource = EnterpriseFacesContextUtility.getResourceIfExists();
        int searchId = currentResource == null ? Integer.parseInt(FacesContextUtility.getOptionalRequestParameter((String)"parent")) : currentResource.getId();
        Subject user = EnterpriseFacesContextUtility.getSubject();
        long start = System.currentTimeMillis();
        long monitorId = HibernatePerformanceMonitor.get().start();
        Resource rootResource = this.resourceManager.getRootResourceForResource(searchId);
        long end = System.currentTimeMillis();
        HibernatePerformanceMonitor.get().stop(monitorId, "ResourceTree root resource");
        log.debug((Object)("Found root resource in " + (end - start)));
        Agent agent = this.agentManager.getAgentByResourceId(rootResource.getId());
        start = System.currentTimeMillis();
        monitorId = HibernatePerformanceMonitor.get().start();
        List resources = this.resourceManager.findResourcesByAgent(user, agent.getId(), PageControl.getUnlimitedInstance());
        end = System.currentTimeMillis();
        HibernatePerformanceMonitor.get().stop(monitorId, "ResourceTree agent resource");
        log.debug((Object)("Loaded " + resources.size() + " raw resources in " + (end - start)));
        start = System.currentTimeMillis();
        monitorId = HibernatePerformanceMonitor.get().start();
        this.rootNode = ResourceTreeModelUIBean.load((int)rootResource.getId(), (List)resources, (boolean)false);
        end = System.currentTimeMillis();
        HibernatePerformanceMonitor.get().stop(monitorId, "ResourceTree tree construction");
        log.debug((Object)("Constructed tree in " + (end - start)));
    }

    public static ResourceTreeNode load(int rootId, List<Resource> resources, boolean alwaysGroup) {
        Resource found = null;
        for (Resource res : resources) {
            if (res.getId() != rootId) continue;
            found = res;
        }
        ResourceTreeNode root = new ResourceTreeNode(found);
        long start = System.currentTimeMillis();
        ResourceTreeModelUIBean.load((ResourceTreeNode)root, (boolean)alwaysGroup);
        return root;
    }

    public static void load(ResourceTreeNode parentNode, boolean alwaysGroup) {
        if (parentNode.getData() instanceof Resource) {
            Resource parentResource = (Resource)parentNode.getData();
            HashMap children = new HashMap();
            for (Resource res : parentResource.getChildResources()) {
                ArrayList<Resource> list;
                if (res.getResourceType().getSubCategory() != null) {
                    if (res.getResourceType().getSubCategory().getParentSubCategory() == null) {
                        if (children.containsKey(res.getResourceType().getSubCategory())) {
                            ((List)children.get(res.getResourceType().getSubCategory())).add(res);
                            continue;
                        }
                        list = new ArrayList();
                        list.add(res);
                        children.put(res.getResourceType().getSubCategory(), list);
                        continue;
                    }
                    if (res.getResourceType().getSubCategory().getParentSubCategory() == null) continue;
                    if (children.containsKey(res.getResourceType().getSubCategory().getParentSubCategory())) {
                        ((List)children.get(res.getResourceType().getSubCategory().getParentSubCategory())).add(res);
                        continue;
                    }
                    list = new ArrayList();
                    list.add(res);
                    children.put(res.getResourceType().getSubCategory().getParentSubCategory(), list);
                    continue;
                }
                if (children.containsKey(res.getResourceType())) {
                    ((List)children.get(res.getResourceType())).add(res);
                    continue;
                }
                list = new ArrayList<Resource>();
                list.add(res);
                children.put(res.getResourceType(), list);
            }
            Set dupResourceTypeNames = ResourceTreeModelUIBean.getDuplicateResourceTypeNames(children, (boolean)alwaysGroup);
            for (Object rsc : children.keySet()) {
                if (rsc != null && (rsc instanceof ResourceSubCategory || ((List)children.get(rsc)).size() > 1 || alwaysGroup && ((List)children.get(rsc)).size() == 1)) {
                    double avail = 0.0;
                    List entries = (List)children.get(rsc);
                    for (Resource res : entries) {
                        avail += res.getCurrentAvailability().getAvailabilityType() == AvailabilityType.UP ? 1.0 : 0.0;
                    }
                    avail /= (double)entries.size();
                    AutoGroupComposite agc = null;
                    if (rsc instanceof ResourceSubCategory) {
                        agc = new AutoGroupComposite(Double.valueOf(avail), parentResource, (ResourceSubCategory)rsc, (long)entries.size());
                    } else if (rsc instanceof ResourceType) {
                        boolean isDupResourceTypeName = dupResourceTypeNames.contains(((ResourceType)rsc).getName());
                        agc = new AutoGroupComposite(Double.valueOf(avail), parentResource, (ResourceType)rsc, (long)entries.size(), isDupResourceTypeName);
                    }
                    ResourceTreeNode node = new ResourceTreeNode(agc);
                    ResourceTreeModelUIBean.load((ResourceTreeNode)node, (boolean)alwaysGroup);
                    if (ResourceTreeModelUIBean.recursivelyLocked((ResourceTreeNode)node)) continue;
                    parentNode.getChildren().add(node);
                    continue;
                }
                List entries = (List)children.get(rsc);
                for (Resource res : entries) {
                    ResourceTreeNode node = new ResourceTreeNode((Object)res);
                    ResourceTreeModelUIBean.load((ResourceTreeNode)node, (boolean)alwaysGroup);
                    if (ResourceTreeModelUIBean.recursivelyLocked((ResourceTreeNode)node)) continue;
                    parentNode.getChildren().add(node);
                }
            }
        } else {
            AutoGroupComposite compositeParent = (AutoGroupComposite)parentNode.getData();
            HashMap children = new HashMap();
            log.debug((Object)("composite parent" + compositeParent));
            if (compositeParent != null) {
                for (Resource res : compositeParent.getParentResource().getChildResources()) {
                    ArrayList<Resource> list;
                    if (compositeParent.getSubcategory() != null) {
                        if (res.getResourceType().getSubCategory() != null && compositeParent.getSubcategory().equals((Object)res.getResourceType().getSubCategory().getParentSubCategory()) && compositeParent.getParentResource().equals((Object)res.getParentResource())) {
                            if (children.containsKey(res.getResourceType().getSubCategory())) {
                                ((List)children.get(res.getResourceType().getSubCategory())).add(res);
                                continue;
                            }
                            list = new ArrayList();
                            list.add(res);
                            children.put(res.getResourceType().getSubCategory(), list);
                            continue;
                        }
                        if (!compositeParent.getSubcategory().equals((Object)res.getResourceType().getSubCategory()) || !compositeParent.getParentResource().equals((Object)res.getParentResource())) continue;
                        if (children.containsKey(res.getResourceType())) {
                            ((List)children.get(res.getResourceType())).add(res);
                            continue;
                        }
                        list = new ArrayList();
                        list.add(res);
                        children.put(res.getResourceType(), list);
                        continue;
                    }
                    if (compositeParent.getResourceType() == null || !compositeParent.getResourceType().equals((Object)res.getResourceType()) || compositeParent.getParentResource().getId() != res.getParentResource().getId()) continue;
                    if (children.containsKey(res.getResourceType())) {
                        ((List)children.get(res.getResourceType())).add(res);
                        continue;
                    }
                    list = new ArrayList<Resource>();
                    list.add(res);
                    children.put(res.getResourceType(), list);
                }
            }
            for (Object rsc : children.keySet()) {
                if (rsc != null && (rsc instanceof ResourceSubCategory || (((List)children.get(rsc)).size() > 1 || alwaysGroup && ((List)children.get(rsc)).size() == 1) && ((AutoGroupComposite)parentNode.getData()).getSubcategory() != null)) {
                    double avail = 0.0;
                    List entries = (List)children.get(rsc);
                    for (Resource res : entries) {
                        avail += res.getCurrentAvailability().getAvailabilityType() == AvailabilityType.UP ? 1.0 : 0.0;
                    }
                    avail /= (double)entries.size();
                    AutoGroupComposite agc = null;
                    if (rsc instanceof ResourceSubCategory) {
                        agc = new AutoGroupComposite(Double.valueOf(avail), compositeParent.getParentResource(), (ResourceSubCategory)rsc, (long)entries.size());
                    } else if (rsc instanceof ResourceType) {
                        agc = new AutoGroupComposite(Double.valueOf(avail), compositeParent.getParentResource(), (ResourceType)rsc, (long)entries.size(), false);
                    }
                    ResourceTreeNode node = new ResourceTreeNode(agc);
                    ResourceTreeModelUIBean.load((ResourceTreeNode)node, (boolean)alwaysGroup);
                    if (ResourceTreeModelUIBean.recursivelyLocked((ResourceTreeNode)node)) continue;
                    parentNode.getChildren().add(node);
                    continue;
                }
                List entries = (List)children.get(rsc);
                for (Resource res : entries) {
                    ResourceTreeNode node = new ResourceTreeNode((Object)res);
                    ResourceTreeModelUIBean.load((ResourceTreeNode)node, (boolean)alwaysGroup);
                    if (ResourceTreeModelUIBean.recursivelyLocked((ResourceTreeNode)node)) continue;
                    parentNode.getChildren().add(node);
                }
            }
        }
    }

    public static boolean recursivelyLocked(ResourceTreeNode node) {
        if (!(node.getData() instanceof LockedResource)) {
            if (node.getData() instanceof Resource) {
                return false;
            }
            if (node.getData() instanceof AutoGroupComposite) {
                // empty if block
            }
        }
        boolean allLocked = true;
        for (ResourceTreeNode child : node.getChildren()) {
            if (ResourceTreeModelUIBean.recursivelyLocked((ResourceTreeNode)child)) continue;
            allLocked = false;
        }
        return allLocked;
    }

    public ResourceTreeNode getTreeNode() {
        if (this.rootNode == null) {
            long start = System.currentTimeMillis();
            this.loadTree();
            log.debug((Object)("Loaded full tree in " + (System.currentTimeMillis() - start)));
        }
        return this.rootNode;
    }

    public List<ResourceTreeNode> getRoots() {
        if (this.roots.isEmpty()) {
            this.roots.add(this.getTreeNode());
        }
        return this.roots;
    }

    public String getNodeTitle() {
        return this.nodeTitle;
    }

    public void setNodeTitle(String nodeTitle) {
        this.nodeTitle = nodeTitle;
    }

    private static Set<String> getDuplicateResourceTypeNames(Map<Object, List<Resource>> children, boolean alwaysGroup) {
        HashSet<String> resourceTypeNames = new HashSet<String>();
        HashSet<String> dupResourceTypeNames = new HashSet<String>();
        for (Object rsc : children.keySet()) {
            if (rsc == null || !(rsc instanceof ResourceType) || children.get(rsc).size() <= 1 && (!alwaysGroup || children.get(rsc).size() != 1)) continue;
            String resourceTypeName = ((ResourceType)rsc).getName();
            if (resourceTypeNames.contains(resourceTypeName)) {
                dupResourceTypeNames.add(resourceTypeName);
            }
            resourceTypeNames.add(resourceTypeName);
        }
        return dupResourceTypeNames;
    }
}

