/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.resource;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.composite.ResourceWithAvailability;
import org.rhq.core.domain.resource.group.composite.AutoGroupComposite;
import org.rhq.core.util.sort.HumaneStringComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTreeNode
implements Comparable<ResourceTreeNode> {
    private static ResourceTreeNode[] CHILDREN_ABSENT = new ResourceTreeNode[0];
    private Set<ResourceTreeNode> children = new TreeSet();
    private Object level;

    public ResourceTreeNode(Object level) {
        this.level = level;
    }

    public ResourceTreeNode(Object level, List<Resource> resources) {
        this.level = level;
    }

    public Set<ResourceTreeNode> getChildren() {
        return this.children;
    }

    public Object getData() {
        return this.level;
    }

    public String toString() {
        if (this.level == null) {
            return "";
        }
        if (this.level instanceof AutoGroupComposite) {
            AutoGroupComposite composite = (AutoGroupComposite)this.level;
            return composite.getName();
        }
        if (this.level instanceof ResourceWithAvailability) {
            return ((ResourceWithAvailability)this.level).getResource().getName();
        }
        if (this.level instanceof Resource) {
            return ((Resource)this.level).getName();
        }
        return this.level.toString();
    }

    @Override
    public int compareTo(ResourceTreeNode that) {
        int i = HumaneStringComparator.DEFAULT.compare(this.toString(), that.toString());
        if (i == 0) {
            i = new Integer(this.level.hashCode()).compareTo(that.level.hashCode());
        }
        return i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceTreeNode that = (ResourceTreeNode)o;
        return this.level.equals(that.level);
    }

    public int hashCode() {
        return this.level.hashCode();
    }
}

