/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.role;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.enterprise.gui.admin.role.AddLdapGroupsForm;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.BaseValidatorForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AddLdapGroupsAction
extends BaseAction {
    LdapGroupManagerLocal ldapManager = LookupUtil.getLdapGroupManager();

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)AddLdapGroupsAction.class.getName());
        HttpSession session = request.getSession();
        AddLdapGroupsForm addForm = (AddLdapGroupsForm)form;
        Integer roleId = addForm.getR();
        ActionForward forward = this.checkSubmit(request, mapping, form, "r", (Object)roleId);
        if (forward != null) {
            BaseValidatorForm spiderForm = (BaseValidatorForm)form;
            if (spiderForm.isCancelClicked() || spiderForm.isResetClicked()) {
                log.debug((Object)"removing pending group list");
                SessionUtils.removeList((HttpSession)session, (String)"pendingResGrps");
            } else if (spiderForm.isAddClicked()) {
                log.debug((Object)"adding to pending group list");
                SessionUtils.addToList((HttpSession)session, (String)"pendingResGrps", (String[])addForm.getAvailableGroups());
            } else if (spiderForm.isRemoveClicked()) {
                log.debug((Object)"removing from pending group list");
                SessionUtils.removeFromList((HttpSession)session, (String)"pendingResGrps", (String[])addForm.getPendingGroups());
            }
            return forward;
        }
        log.debug((Object)"getting pending group list");
        List pendingGroupIds = SessionUtils.getListAsListStr((HttpSession)request.getSession(), (String)"pendingResGrps");
        for (String id : pendingGroupIds) {
            log.debug((Object)("adding group [" + id + "] for role [" + roleId + "]"));
        }
        this.ldapManager.addLdapGroupsToRole(RequestUtils.getSubject((HttpServletRequest)request), roleId.intValue(), pendingGroupIds);
        log.debug((Object)"removing pending group list");
        SessionUtils.removeList((HttpSession)session, (String)"pendingResGrps");
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"admin.role.confirm.AddLdapGroups");
        return this.returnSuccess(request, mapping, "r", (Object)roleId);
    }
}

