/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.role;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.enterprise.gui.admin.role.RoleForm;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class NewAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)NewAction.class.getName());
        RoleForm newForm = (RoleForm)form;
        ActionForward forward = this.checkSubmit(request, mapping, form, true);
        if (forward != null) {
            return forward;
        }
        Role role = new Role(newForm.getName());
        role.setDescription(newForm.getDescription());
        role.setFsystem(Boolean.valueOf(false));
        List newPermissionStrings = newForm.getPermissionsStrings();
        for (String permString : newPermissionStrings) {
            Permission p = Enum.valueOf(Permission.class, permString);
            role.addPermission(p);
        }
        log.trace((Object)("creating role [" + role.getName() + "] with attributes " + newForm));
        try {
            RoleManagerLocal roleManager = LookupUtil.getRoleManager();
            role = roleManager.createRole(RequestUtils.getSubject((HttpServletRequest)request), role);
        }
        catch (Exception ex) {
            log.debug((Object)"role creation failed:", (Throwable)ex);
            RequestUtils.setError((HttpServletRequest)request, (String)"admin.role.error.BadRole");
            return this.returnFailure(request, mapping);
        }
        log.trace((Object)("new role id: [" + role.getId() + "]"));
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"admin.role.confirm.Create", (Object)role.getName());
        return this.returnNew(request, mapping, "r", (Object)role.getId());
    }
}

