/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.user;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.admin.user.EditForm;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.auth.prefs.SubjectPreferences;
import org.rhq.enterprise.server.util.LookupUtil;

public class EditAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)EditAction.class.getName());
        log.trace((Object)"modifying user properties action");
        EditForm userForm = (EditForm)form;
        ActionForward forward = this.checkSubmit(request, mapping, form, "u", (Object)userForm.getId());
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject user = subjectManager.loadUserConfiguration(userForm.getId());
        if (forward != null) {
            request.setAttribute("User", (Object)user);
            return forward;
        }
        user.setFirstName(userForm.getFirstName());
        user.setLastName(userForm.getLastName());
        user.setDepartment(userForm.getDepartment());
        user.setName(userForm.getName());
        user.setEmailAddress(userForm.getEmailAddress());
        user.setPhoneNumber(userForm.getPhoneNumber());
        user.setSmsAddress(userForm.getSmsAddress());
        user.setFactive(userForm.getEnableLogin().equals("yes"));
        WebUser currentUser = RequestUtils.getWebUser((HttpServletRequest)request);
        if (currentUser.getId().equals(userForm.getId())) {
            try {
                WebUserPreferences webPreferences = currentUser.getWebPreferences();
                int pageRefreshPeriod = Integer.valueOf(userForm.getPageRefreshPeriod());
                webPreferences.setPageRefreshPeriod(pageRefreshPeriod);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("pageRefreshPeriod is not an integer, this should have been caught earlier by the form validation.");
            }
            try {
                SubjectPreferences corePreferences = currentUser.getSubjectPreferences();
                int timeoutPeriod = Integer.valueOf(userForm.getGroupConfigurationTimeout());
                corePreferences.setGroupConfigurationTimeoutPeriod(timeoutPeriod);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("groupConfigurationTimeout is not an integer, this should have been caught earlier by the form validation.");
            }
        }
        subjectManager.updateSubject(currentUser.getSubject(), user);
        return this.returnSuccess(request, mapping, "u", (Object)userForm.getId());
    }
}

