/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.enterprise.gui.admin.user.NewForm;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.exception.LdapCommunicationException;
import org.rhq.enterprise.server.exception.LdapFilterException;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RegisterAction
extends BaseAction {
    SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
    SystemManagerLocal systemManager = LookupUtil.getSystemManager();
    LdapGroupManagerLocal ldapManager = LookupUtil.getLdapGroupManager();

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)RegisterAction.class.getName());
        NewForm userForm = (NewForm)form;
        HttpSession session = request.getSession(false);
        ActionForward forward = this.checkSubmit(request, mapping, form);
        if (forward != null) {
            return forward;
        }
        WebUser webUser = SessionUtils.getWebUser((HttpSession)session);
        Subject newSubject = new Subject();
        newSubject.setName(webUser.getUsername());
        newSubject.setFirstName(userForm.getFirstName());
        newSubject.setLastName(userForm.getLastName());
        newSubject.setDepartment(userForm.getDepartment());
        newSubject.setEmailAddress(userForm.getEmailAddress());
        newSubject.setPhoneNumber(userForm.getPhoneNumber());
        newSubject.setSmsAddress(userForm.getSmsAddress());
        newSubject.setFactive(true);
        newSubject.setFsystem(false);
        Configuration userPrefs = (Configuration)this.getServlet().getServletContext().getAttribute("userPrefs");
        newSubject.setUserConfiguration(userPrefs);
        String password = (String)session.getAttribute("password");
        session.removeAttribute("password");
        Subject superuser = this.subjectManager.getOverlord();
        log.trace((Object)("registering new LDAP-authenticated subject [" + newSubject.getName() + "]"));
        this.subjectManager.createSubject(superuser, newSubject);
        this.subjectManager.logout(RequestUtils.getSessionId((HttpServletRequest)request).intValue());
        newSubject = this.subjectManager.login(newSubject.getName(), password);
        webUser = new WebUser(newSubject);
        SessionUtils.setWebUser((HttpSession)session, (WebUser)webUser);
        session.setAttribute("useroperations", new HashMap());
        HashMap<String, Integer> parms = new HashMap<String, Integer>(1);
        parms.put("u", newSubject.getId());
        Properties options = this.systemManager.getSystemConfiguration();
        String groupFilter = options.getProperty("CAM_LDAP_GROUP_FILTER", "");
        String groupMember = options.getProperty("CAM_LDAP_GROUP_MEMBER", "");
        if (groupFilter.trim().length() > 0 || groupMember.trim().length() > 0) {
            try {
                String provider = LookupUtil.getSystemManager().getSystemConfiguration().getProperty("CAM_JAAS_PROVIDER");
                if ("LDAP".equals(provider)) {
                    ArrayList groupNames = new ArrayList(this.ldapManager.findAvailableGroupsFor(newSubject.getName()));
                    this.ldapManager.assignRolesToLdapSubject(newSubject.getId(), groupNames);
                }
            }
            catch (EJBException ejx) {
                Exception cause = ejx.getCausedByException();
                if (cause == null) {
                    ActionMessages actionMessages = new ActionMessages();
                    actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.cam.general"));
                    this.saveErrors(request, actionMessages);
                } else if (cause instanceof LdapFilterException) {
                    ActionMessages actionMessages = new ActionMessages();
                    actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("admin.role.LdapGroupFilterMessage"));
                    this.saveErrors(request, actionMessages);
                } else if (cause instanceof LdapCommunicationException) {
                    ActionMessages actionMessages = new ActionMessages();
                    SystemManagerLocal manager = LookupUtil.getSystemManager();
                    options = manager.getSystemConfiguration();
                    String providerUrl = options.getProperty("CAM_LDAP_NAMING_PROVIDER_URL", "(unavailable)");
                    actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("admin.role.LdapCommunicationMessage", (Object)providerUrl));
                    this.saveErrors(request, actionMessages);
                }
            }
            catch (LdapFilterException lce) {
                ActionMessages actionMessages = new ActionMessages();
                actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("admin.role.LdapGroupFilterMessage"));
                this.saveErrors(request, actionMessages);
            }
            catch (LdapCommunicationException lce) {
                ActionMessages actionMessages = new ActionMessages();
                String providerUrl = options.getProperty("CAM_LDAP_NAMING_PROVIDER_URL", "(unavailable)");
                actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("admin.role.LdapCommunicationMessage", (Object)providerUrl));
                this.saveErrors(request, actionMessages);
            }
        }
        return this.returnSuccess(request, mapping, parms, false);
    }
}

