/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert.common;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.rhq.enterprise.gui.alert.common.AlertNotificationContextUIBean;
import org.rhq.enterprise.gui.common.framework.EnterpriseFacesContextUIBean;

@Scope(value=ScopeType.EVENT)
@Name(value="AlertNotificationContextUIBean")
public class AlertNotificationContextUIBean
extends EnterpriseFacesContextUIBean {
    @RequestParameter(value="context")
    private String context;
    @RequestParameter(value="contextId")
    private Integer contextId;
    @RequestParameter(value="contextSubId")
    private Integer contextSubId;
    private String name;
    private String redirect;
    private String refresh;

    @Create
    public void init() {
        if (this.context.equals("template")) {
            this.name = "Alert Notification Template";
            this.redirect = this.create(Context.AlertNotificationTemplate, new Object[]{"mode", "view", "templateId", this.contextId});
        } else if (this.context.equals("resource")) {
            this.name = "Resource Alert Definition";
            this.redirect = this.create(Context.ResourceAlertDefinition, new Object[]{"mode", "viewRoles", "ad", this.contextId, "id", this.contextSubId});
        } else if (this.context.equals("group")) {
            this.name = "Group Alert Definition";
            this.redirect = this.create(Context.GroupAlertDefinition, new Object[]{"mode", "viewRoles", "ad", this.contextId, "groupId", this.contextSubId});
        } else if (this.context.equals("type")) {
            this.name = "Alert Template";
            this.redirect = this.create(Context.AlertTemplate, new Object[]{"mode", "viewRoles", "ad", this.contextId, "type", this.contextSubId});
        }
        this.refresh = this.create(Context.NotificationDetails, new Object[]{"context", this.context, "contextId", this.contextId, "contextSubId", this.contextSubId});
    }

    public String create(Context context, Object ... nameValuePairs) {
        StringBuilder results = new StringBuilder();
        if (context == Context.AlertNotificationTemplate) {
            results.append("/rhq/admin/alert/template/notification/details.xhtml");
        } else if (context == Context.NotificationDetails) {
            results.append("rhq/common/alert/notification/details.xhtml");
        } else {
            results.append("/alerts/Config.do");
        }
        results.append("?");
        for (int i = 0; i < nameValuePairs.length; i += 2) {
            if (i != 0) {
                results.append("&");
            }
            if (nameValuePairs[i + 1] == null) continue;
            results.append(nameValuePairs[i]);
            results.append("=");
            results.append(nameValuePairs[i + 1]);
        }
        return results.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public String getRefresh() {
        return this.refresh;
    }

    public String getContext() {
        return this.context;
    }

    public Integer getContextId() {
        return this.contextId;
    }

    public Integer getContextSubId() {
        return this.contextSubId;
    }
}

