/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.paging;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.util.HibernatePerformanceMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PagedListDataModel<T>
extends DataModel {
    private final Log log = LogFactory.getLog(PagedListDataModel.class);
    private int currentRowIndex = -1;
    private PageControlView pageControlView;
    private PageList<T> pageList;
    private String beanName;

    public PagedListDataModel(PageControlView view, String beanName) {
        this.pageControlView = view;
        this.pageList = null;
        this.beanName = beanName;
    }

    public void setWrappedData(Object o) {
        throw new UnsupportedOperationException("setWrappedData");
    }

    public int getRowIndex() {
        return this.currentRowIndex;
    }

    public void setRowIndex(int index) {
        this.currentRowIndex = index;
    }

    public int getRowCount() {
        return this.getPage().getTotalSize();
    }

    private PageList<T> getPage() {
        if (this.pageList == null) {
            PageList results;
            PageControl pageControl = this.getPageControl();
            this.pageList = results = this.getDataPage(pageControl);
        }
        return this.pageList;
    }

    public Object getRowData() {
        int endRow;
        if (this.currentRowIndex < 0) {
            throw new IllegalArgumentException("Invalid rowIndex for PagedListDataModel; not within page");
        }
        PageControl pageControl = this.getPageControl();
        int startRow = pageControl.getStartRow();
        if (pageControl.getPageSize() == -1) {
            endRow = Integer.MAX_VALUE;
        } else {
            int nRows = pageControl.getPageSize();
            endRow = startRow + nRows - 1;
        }
        if (this.currentRowIndex < startRow) {
            int rowsBack = startRow - this.currentRowIndex;
            int pagesBack = (int)Math.ceil((double)rowsBack / (double)pageControl.getPageSize());
            int newPage = pageControl.getPageNumber() - pagesBack;
            if (newPage < 0) {
                newPage = 0;
            }
            pageControl.setPageNumber(newPage);
            this.pageList = this.getDataPage(pageControl);
            startRow = pageControl.getStartRow();
        } else if (this.currentRowIndex > endRow) {
            int rowsForward = this.currentRowIndex - endRow;
            int pagesForward = (int)Math.ceil((double)rowsForward / (double)pageControl.getPageSize());
            int newPage = pageControl.getPageNumber() + pagesForward;
            pageControl.setPageNumber(newPage);
            this.pageList = this.getDataPage(pageControl);
            startRow = pageControl.getStartRow();
        }
        int getIndex = this.currentRowIndex - startRow;
        if (getIndex < 0 || getIndex >= this.pageList.size()) {
            pageControl = this.getDefaultPageControl();
            this.pageList = this.getDataPage(pageControl);
            this.currentRowIndex = 0;
            getIndex = 0;
        }
        return this.pageList.get(getIndex);
    }

    public Object getWrappedData() {
        return this.pageList;
    }

    public boolean isRowAvailable() {
        PageList page = this.getPage();
        if (page == null) {
            return false;
        }
        int rowIndex = this.getRowIndex();
        if (rowIndex < 0) {
            return false;
        }
        return rowIndex < page.getTotalSize();
    }

    private PagedDataTableUIBean getPagedDataTableUIBean() {
        FacesContext facesContext = FacesContextUtility.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        PagedDataTableUIBean result = (PagedDataTableUIBean)externalContext.getRequestMap().get(this.beanName);
        if (result == null) {
            result = (PagedDataTableUIBean)externalContext.getSessionMap().get(this.beanName);
        }
        return result;
    }

    public PageControl getPageControl() {
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        return this.getPagedDataTableUIBean().getPageControl(user, this.pageControlView);
    }

    public PageControl getDefaultPageControl() {
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        return this.getPagedDataTableUIBean().getDefaultPageControl(user, this.pageControlView);
    }

    public void setPageControl(PageControl pageControl) {
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        this.getPagedDataTableUIBean().setPageControl(user, this.pageControlView, pageControl);
    }

    public PageList<T> getDataPage(PageControl pc) {
        long start = System.currentTimeMillis();
        long monitorId = HibernatePerformanceMonitor.get().start();
        PageList results = this.fetchPageGuarded(pc);
        HibernatePerformanceMonitor.get().stop(monitorId, this.pageControlView.toString());
        if (this.log.isDebugEnabled()) {
            long time = System.currentTimeMillis() - start;
            this.log.debug((Object)("Fetch time was [" + time + "]ms for " + this.pageControlView));
            if (time > 2000L) {
                this.log.debug((Object)("Slow loading page " + this.pageControlView));
            }
        }
        return results;
    }

    private PageList<T> fetchPageGuarded(PageControl pc) {
        PageList results = null;
        boolean tryQueryAgain = false;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(this.pageControlView + ": " + pc));
            }
            if (pc.getPageSize() == -1 && pc.getPageNumber() != 0) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(this.pageControlView + ": Forcing UNLIMITED PageControl's pageNumber to 0"));
                }
                pc.setPageNumber(0);
                this.setPageControl(pc);
            }
            results = this.fetchPage(pc);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(this.pageControlView + ": Successfully fetched page (first time)"));
            }
            if (results.getTotalSize() < pc.getStartRow() || results.isEmpty() && pc.getPageNumber() != 0) {
                if (this.log.isTraceEnabled()) {
                    if (results.getTotalSize() < pc.getStartRow()) {
                        this.log.trace((Object)(this.pageControlView + ": Results size[" + results.getTotalSize() + "] was less than PageControl startRow[" + pc.getStartRow() + "]"));
                    } else {
                        this.log.trace((Object)(this.pageControlView + ": Results were empty, but pageNumber was non-zero"));
                    }
                }
                this.resetToDefaults(pc);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(this.pageControlView + ": resetting to " + pc));
                }
                tryQueryAgain = true;
            }
        }
        catch (Throwable t) {
            this.resetToDefaults(pc);
            this.log.error((Object)(this.pageControlView + ": Received error[" + t.getMessage() + "], resetting to " + pc));
            tryQueryAgain = true;
        }
        if (tryQueryAgain) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(this.pageControlView + ": Trying query again"));
            }
            try {
                results = this.fetchPage(pc);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(this.pageControlView + ": Successfully fetched page (second time)"));
                }
            }
            catch (Throwable t) {
                this.log.error((Object)("Could not retrieve collection for " + this.pageControlView), t);
            }
        }
        if (results == null) {
            results = new PageList();
        }
        return results;
    }

    private void resetToDefaults(PageControl pc) {
        pc.reset();
        this.setPageControl(pc);
    }

    public abstract PageList<T> fetchPage(PageControl var1);

    public PageControlView getPageControlView() {
        return this.pageControlView;
    }
}

