/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.servlet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.enterprise.gui.common.servlet.ChartServlet;
import org.rhq.enterprise.gui.common.servlet.HighLowMetricValue;
import org.rhq.enterprise.gui.image.chart.Chart;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.chart.HighLowChart;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class HighLowChartServlet
extends ChartServlet
implements SingleThreadModel {
    private static final int NUMBER_OF_DATA_POINTS = 60;
    private final Log log = LogFactory.getLog(HighLowChartServlet.class);
    private int scheduleId;
    private int definitionId;
    private int groupId;
    private int parentId;
    private int childTypeId;

    protected Chart createChart() {
        return new HighLowChart(this.getImageWidth(), this.getImageHeight());
    }

    protected void initializeChart(Chart chart) {
        super.initializeChart(chart);
        HighLowChart highLowChart = (HighLowChart)chart;
        highLowChart.setNumberDataSets(1);
        highLowChart.leftBorder = 0;
        highLowChart.rightLabelWidth = (int)((double)this.getImageWidth() * 0.1);
        highLowChart.columnWidth = 7;
    }

    protected void parseParameters(HttpServletRequest request) {
        this.scheduleId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"schedId", (int)-1);
        this.groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
        this.parentId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
        this.childTypeId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
        this.definitionId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"definitionId", (int)-1);
        String parameter = request.getParameter("measurementUnits");
        if (parameter == null || parameter.equals("")) {
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            this.units = this.scheduleId > 0 ? this.getUnitsFromScheduleId(overlord, this.scheduleId) : this.getUnitsFromDefinitionId(overlord, this.definitionId);
            this.log.debug((Object)("Caller did not pass MeasuremntUnits, calculated them as " + this.units.getName()));
        } else {
            this.log.debug((Object)("Caller passed MeasurementUnits of " + parameter));
        }
        super.parseParameters(request);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void plotData(HttpServletRequest request, Chart chart) throws ServletException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Requesting: " + request.getQueryString()));
        }
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        Subject subject = user.getSubject();
        MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
        MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        long beginTime = rangePreferences.begin;
        long endTime = rangePreferences.end;
        List dataPoints = null;
        if (this.scheduleId > 0) {
            MeasurementSchedule schedule = scheduleManager.getScheduleById(subject, this.scheduleId);
            if (schedule == null) {
                this.log.debug((Object)("Passed scheduleId " + this.scheduleId + " has no schedule attached, ignoring"));
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Plotting a high-low chart data for metric " + schedule.getDefinition().getName() + " on resource " + schedule.getResource().getName() + "..."));
            }
            dataPoints = (List)dataManager.findDataForResource(subject, schedule.getResource().getId(), new int[]{schedule.getDefinition().getId()}, beginTime, endTime, 60).get(0);
        } else if (this.groupId > 0 && this.definitionId > 0) {
            dataPoints = (List)dataManager.findDataForCompatibleGroup(subject, this.groupId, this.definitionId, beginTime, endTime, 60, true).get(0);
        } else if (this.parentId > 0 && this.childTypeId > 0 && this.definitionId > 0) {
            dataPoints = (List)dataManager.findDataForAutoGroup(subject, this.parentId, this.childTypeId, this.definitionId, beginTime, endTime, 60, true).get(0);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No valid input found for HighLowChart: [schedId=" + this.scheduleId + ", defId=" + this.definitionId + ", groupId=" + this.groupId + ", parentId=" + this.parentId + ", childTypeId=" + this.childTypeId + "]"));
            }
            return;
        }
        ArrayList<HighLowMetricValue> chartDataPoints = new ArrayList<HighLowMetricValue>(dataPoints.size());
        Iterator i$ = dataPoints.iterator();
        while (true) {
            if (!i$.hasNext()) {
                HighLowChart highLowChart = (HighLowChart)chart;
                DataPointCollection bars = highLowChart.getDataPoints(0);
                bars.addAll(chartDataPoints);
                return;
            }
            MeasurementDataNumericHighLowComposite dataPoint = (MeasurementDataNumericHighLowComposite)i$.next();
            chartDataPoints.add(new HighLowMetricValue(dataPoint));
        }
    }

    private MeasurementUnits getUnitsFromScheduleId(Subject subject, int measurementScheduleId) {
        MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
        MeasurementSchedule schedule = scheduleManager.getScheduleById(subject, measurementScheduleId);
        return schedule.getDefinition().getUnits();
    }

    private MeasurementUnits getUnitsFromDefinitionId(Subject subject, int measurementDefinitionId) {
        MeasurementDefinitionManagerLocal definitionManager = LookupUtil.getMeasurementDefinitionManager();
        MeasurementDefinition definition = definitionManager.getMeasurementDefinition(subject, measurementDefinitionId);
        return definition.getUnits();
    }
}

