/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletePackagesUIBean {
    private Resource resource;
    private String[] packageIdsToDelete;
    private List<InstalledPackage> packagesToDelete;
    private String notes;

    public String beginDeleteWorkflow() {
        this.getPackageIdsToDelete();
        return "beginDeleteWorkflow";
    }

    public String deleteSelectedInstalledPackages() {
        if (this.notes != null && this.notes.length() > 512) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Package notes must be 512 characters or less.");
            return null;
        }
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        this.resource = EnterpriseFacesContextUtility.getResource();
        String[] selectedPackages = (String[])FacesContextUtility.getRequest().getSession().getAttribute("packageIdsToDelete");
        int[] installedPackageIds = new int[selectedPackages.length];
        for (int i = 0; i < selectedPackages.length; ++i) {
            installedPackageIds[i] = Integer.parseInt(selectedPackages[i]);
        }
        try {
            ContentManagerLocal contentManager = LookupUtil.getContentManager();
            contentManager.deletePackages(subject, this.resource.getId(), installedPackageIds, this.notes);
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to delete packages. Cause: " + e));
        }
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return "successOrFailure";
    }

    public Resource getResource() {
        if (this.resource == null) {
            this.resource = EnterpriseFacesContextUtility.getResource();
        }
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public List<InstalledPackage> getPackagesToDelete() {
        if (this.packagesToDelete == null) {
            if (this.getPackageIdsToDelete() == null) {
                return Collections.EMPTY_LIST;
            }
            this.packagesToDelete = new ArrayList(this.packageIdsToDelete.length);
            ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
            for (String installedPackageId : this.packageIdsToDelete) {
                int iInstalledPackageId = Integer.parseInt(installedPackageId);
                InstalledPackage installedPackage = contentUIManager.getInstalledPackage(iInstalledPackageId);
                this.packagesToDelete.add(installedPackage);
            }
        }
        return this.packagesToDelete;
    }

    public void setPackagesToDelete(List<InstalledPackage> packagesToDelete) {
        this.packagesToDelete = packagesToDelete;
    }

    public String[] getPackageIdsToDelete() {
        HttpServletRequest request = FacesContextUtility.getRequest();
        HttpSession session = request.getSession();
        if (request.getParameterValues("selectedPackages") != null) {
            this.packageIdsToDelete = request.getParameterValues("selectedPackages");
            session.setAttribute("packageIdsToDelete", (Object)this.packageIdsToDelete);
        } else {
            this.packageIdsToDelete = (String[])session.getAttribute("packageIdsToDelete");
        }
        return this.packageIdsToDelete;
    }

    public void setPackageIdsToDelete(String[] packageIdsToDelete) {
        this.packageIdsToDelete = packageIdsToDelete;
    }

    public String getNotes() {
        if (this.notes == null) {
            List installedPackages = this.getPackagesToDelete();
            StringBuffer sb = new StringBuffer("Packages: ");
            int counter = 0;
            for (InstalledPackage installedPackage : installedPackages) {
                PackageVersion packageVersion = installedPackage.getPackageVersion();
                Package generalPackage = packageVersion.getGeneralPackage();
                String version = packageVersion.getDisplayVersion() != null ? packageVersion.getDisplayVersion() : packageVersion.getVersion();
                String packageToAppend = generalPackage.getName() + " " + version;
                if (sb.toString().length() + packageToAppend.length() > 508) {
                    if (counter != installedPackages.size() - 1) {
                        sb.append("...");
                        break;
                    }
                    if (sb.toString().length() + packageToAppend.length() <= 511) {
                        sb.append(packageToAppend);
                        break;
                    }
                    sb.append("...");
                    break;
                }
                sb.append(packageToAppend);
                if (counter++ >= installedPackages.size() - 1) continue;
                sb.append(", ");
            }
            this.notes = sb.toString();
        }
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }
}

