/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.RepoUnsubscriptionsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RepoUnsubscriptionsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "RepoUnsubscriptionsUIBean";
    private String searchString = null;
    private String searchCategory = null;
    private static final IntExtractor<Resource> RESOURCE_ID_EXTRACTOR = new /* Unavailable Anonymous Inner Class!! */;

    public String getSearchCategory() {
        if (this.searchCategory == null) {
            this.searchCategory = ResourceCategory.PLATFORM.name();
        }
        return this.searchCategory;
    }

    public void setSearchCategory(String category) {
        this.searchCategory = category;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String associateSelectedContentSourcesWithRepo() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedRepoUnsubscriptions();
        int repoId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        int[] resourceIds = this.getIntegerArray(selected);
        if (resourceIds != null && resourceIds.length > 0) {
            try {
                RepoManagerLocal manager = LookupUtil.getRepoManagerLocal();
                for (int resourceId : resourceIds) {
                    manager.subscribeResourceToRepos(subject, resourceId, new int[]{repoId});
                }
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Subscribed [" + resourceIds.length + "] resources with repo"));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to subscribe one or more resources with repo", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new RepoUnsubscriptionsDataModel(this, PageControlView.RepoUnsubscriptionsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedRepoUnsubscriptions() {
        return FacesContextUtility.getRequest().getParameterValues("selectedRepoUnsubscriptions");
    }

    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }

    static /* synthetic */ IntExtractor access$000() {
        return RESOURCE_ID_EXTRACTOR;
    }
}

