/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.enterprise.gui.image.chart.ChartGraphics;
import org.rhq.enterprise.gui.image.chart.HealthChart;

public class AvailabilityChart
extends HealthChart {
    private static final String DEF_UNIT = "%";
    private static final Color DEF_AVAIL_COLOR = GOOD_COLOR;
    private static final Color DEF_NOT_AVAIL_COLOR = DANGER_COLOR;

    public AvailabilityChart(int width, int height) {
        super(width, height);
    }

    protected void init() {
        super.init();
        this.showAverage = false;
        this.showFullLabels = true;
        this.showRightLabels = false;
        this.showLeftLegend = false;
        this.showBottomLegend = false;
        this.showLow = false;
        this.showPeak = false;
        this.showValueLines = true;
        this.floor = 0.0;
        this.ceiling = 1.0;
        this.valueLines = 5;
        this.setFormat(MeasurementUnits.PERCENTAGE);
    }

    protected void paint(ChartGraphics g, Rectangle rect) {
        Rectangle rectBar = new Rectangle();
        int cDataPoints = this.getDataPoints().size();
        for (int i = 0; i < cDataPoints; ++i) {
            Point ptData = this.getDataPoint(rect, i);
            if (ptData == null) continue;
            double dVal = this.getDataPoints().get(i).getValue();
            rectBar.x = ptData.x - this.columnWidth / 2;
            rectBar.width = this.columnWidth;
            rectBar.y = ptData.y;
            rectBar.height = rect.y + rect.height - rectBar.y;
            if (dVal < 100.0) {
                g.graphics.setColor(DEF_NOT_AVAIL_COLOR);
                g.graphics.fillRect(rectBar.x, rect.y + this.lineWidth, rectBar.width, rectBar.y - rect.y);
            }
            if (!(dVal > 0.0)) continue;
            g.graphics.setColor(DEF_AVAIL_COLOR);
            g.graphics.fillRect(rectBar.x, rectBar.y, rectBar.width, rectBar.height);
        }
    }
}

