/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.browse;

import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.html.HtmlInputText;
import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.composite.ResourceComposite;
import org.rhq.core.domain.search.SavedSearch;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.core.domain.search.SearchSuggestion;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.inventory.browse.BrowseResourcesUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.search.SavedSearchManagerLocal;
import org.rhq.enterprise.server.search.execution.SearchAssistManager;
import org.rhq.enterprise.server.util.HibernatePerformanceMonitor;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseResourcesUIBean
extends PagedDataTableUIBean {
    protected final Log log = LogFactory.getLog(BrowseResourcesUIBean.class);
    public static final String MANAGED_BEAN_NAME = "BrowseResourcesUIBean";
    private String search;
    private HtmlInputText searchInput;
    private ResourceCategory category;
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private SavedSearchManagerLocal savedSearchManager = LookupUtil.getSavedSearchManager();
    private static final IntExtractor<ResourceComposite> RESOURCE_ID_EXTRATOR = new /* Unavailable Anonymous Inner Class!! */;
    SearchAssistManager searchAssist = new SearchAssistManager(this.getSubject(), SearchSubsystem.RESOURCE);

    public BrowseResourcesUIBean() {
        String subtab = FacesContextUtility.getOptionalRequestParameter((String)"subtab", (String)"").toLowerCase();
        if (subtab.equals("platform")) {
            this.category = ResourceCategory.PLATFORM;
        } else if (subtab.equals("server")) {
            this.category = ResourceCategory.SERVER;
        } else if (subtab.equals("service")) {
            this.category = ResourceCategory.SERVICE;
        }
        String searchId = FacesContextUtility.getOptionalRequestParameter((String)"searchId");
        if (searchId != null) {
            SavedSearch savedSearch = this.savedSearchManager.getSavedSearchById(this.getSubject(), Integer.valueOf(searchId).intValue());
            this.search = savedSearch.getPattern();
        } else {
            this.search = FacesContextUtility.getOptionalRequestParameter((String)"search");
        }
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public ResourceCategory getCategory() {
        return this.category;
    }

    public synchronized DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ResultsDataModel(this, PageControlView.BrowseResources, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    public String uninventorySelectedResources() {
        try {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            String[] selectedResources = this.getSelectedItems();
            int[] resourceIds = StringUtility.getIntArray((String[])selectedResources);
            this.resourceManager.uninventoryResources(subject, resourceIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Uninventoried selected resources");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to uninventory selected resources", (Throwable)e);
        }
        return "success";
    }

    private String[] getSelectedItems() {
        return FacesContextUtility.getRequest().getParameterValues("selectedItems");
    }

    public List<SearchSuggestion> autocomplete(Object suggest) {
        String currentInputText = (String)suggest;
        long id = HibernatePerformanceMonitor.get().start();
        List suggestions = this.searchAssist.getSuggestions(currentInputText, currentInputText.length());
        HibernatePerformanceMonitor.get().stop(id, "ResourceSuggestions");
        return suggestions;
    }

    public HtmlInputText getSearchInput() {
        return this.searchInput;
    }

    public void setSearchInput(HtmlInputText searchInput) {
        this.searchInput = searchInput;
    }

    static /* synthetic */ ResourceManagerLocal access$000(BrowseResourcesUIBean x0) {
        return x0.resourceManager;
    }

    static /* synthetic */ IntExtractor access$100() {
        return RESOURCE_ID_EXTRATOR;
    }
}

