/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib.display;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.taglibs.standard.tag.el.core.ExpressionUtil;
import org.rhq.enterprise.gui.legacy.taglib.display.ColumnDecorator;
import org.rhq.enterprise.gui.legacy.taglib.display.ColumnTag;
import org.rhq.enterprise.gui.legacy.taglib.display.QuicknavDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QuicknavDecorator
extends ColumnDecorator
implements Tag {
    protected static final String DATA_TABLE_STYLE_CLASS = "data-table";
    protected static final String QUICKNAV_CELL_STYLE_CLASS = "quicknav-cell";
    protected static final String QUICKNAV_BLOCK_STYLE_CLASS = "quicknav-block";
    private static final IconInfo MONITOR_ICON_INFO = new IconInfo("/images/icons/Monitor_grey_16.png", "Monitor");
    private static final IconInfo EVENT_ICON_INFO = new IconInfo("/images/icons/Events_grey_16.png", "Events");
    private static final IconInfo INVENTORY_ICON_INFO = new IconInfo("/images/icons/Inventory_grey_16.png", "Inventory");
    private static final IconInfo CONFIGURE_ICON_INFO = new IconInfo("/images/icons/Configure_grey_16.png", "Configure");
    private static final IconInfo OPERATIONS_ICON_INFO = new IconInfo("/images/icons/Operation_grey_16.png", "Operations");
    private static final IconInfo ALERT_ICON_INFO = new IconInfo("/images/icons/Alert_grey_16.png", "Alerts");
    private static final IconInfo CONTENT_ICON_INFO = new IconInfo("/images/icons/Content_grey_16.png", "Content");
    private static final String ICON_SRC_LOCKED = "/images/icon_hub_locked.gif";
    private static final String ICON_WIDTH = "16";
    private static final String ICON_HEIGHT = "16";
    protected static final Log LOG = LogFactory.getLog((String)QuicknavDecorator.class.getName());
    private Tag parentTag;

    protected String getOutput() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table class=\"").append(DATA_TABLE_STYLE_CLASS).append("\"><tr>");
        this.appendCell(stringBuilder, this.isMonitorSupported(), this.isMonitorAllowed(), this.getMonitorURL(), MONITOR_ICON_INFO);
        this.appendCell(stringBuilder, this.isInventorySupported(), this.isInventoryAllowed(), this.getInventoryURL(), INVENTORY_ICON_INFO);
        this.appendCell(stringBuilder, this.isAlertSupported(), this.isAlertAllowed(), this.getAlertURL(), ALERT_ICON_INFO);
        this.appendCell(stringBuilder, this.isConfigureSupported(), this.isConfigureAllowed(), this.getConfigureURL(), CONFIGURE_ICON_INFO);
        this.appendCell(stringBuilder, this.isOperationsSupported(), this.isOperationsAllowed(), this.getOperationsURL(), OPERATIONS_ICON_INFO);
        this.appendCell(stringBuilder, this.isEventsSupported(), this.isEventsAllowed(), this.getEventsURL(), EVENT_ICON_INFO);
        this.appendCell(stringBuilder, this.isContentSupported(), this.isContentAllowed(), this.getContentURL(), CONTENT_ICON_INFO);
        stringBuilder.append("</tr></table>");
        return stringBuilder.toString();
    }

    private void appendCell(StringBuilder stringBuilder, boolean facetSupported, boolean facetAllowed, String tabUrl, IconInfo iconInfo) {
        stringBuilder.append("<td class=\"").append(QUICKNAV_CELL_STYLE_CLASS).append("\">");
        stringBuilder.append("<div class=\"").append(QUICKNAV_BLOCK_STYLE_CLASS).append("\">");
        if (facetSupported) {
            if (facetAllowed) {
                this.appendLinkedIcon(stringBuilder, tabUrl, iconInfo);
            } else {
                this.appendLockedIcon(stringBuilder);
            }
        }
        stringBuilder.append("</div></td>");
    }

    protected String getNA() {
        return "";
    }

    protected void appendLockedIcon(StringBuilder stringBuilder) {
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        stringBuilder.append("<img src=\"").append(request.getContextPath()).append(ICON_SRC_LOCKED).append("\" width=\"").append("16").append("\" height=\"").append("16").append("\" alt=\"Locked\" />\n");
    }

    protected void appendLinkedIcon(StringBuilder stringBuilder, String url, IconInfo iconInfo) {
        String fullTargetURL = this.getFullURL(url);
        this.makeLinkedIconWithRef(stringBuilder, fullTargetURL, iconInfo.getSrc(), iconInfo.getTitle());
    }

    protected abstract String getFullURL(String var1);

    private void makeLinkedIconWithRef(StringBuilder stringBuilder, String targetURL, String imageURL, String imageTitle) {
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        stringBuilder.append("<a href=\"").append(targetURL).append("\">");
        stringBuilder.append("<img src=\"").append(request.getContextPath()).append(imageURL).append("\" width=\"").append("16").append("\" height=\"").append("16").append("\" title=\"").append(imageTitle).append("\" alt=\"").append(imageTitle).append("\" />");
        stringBuilder.append("</a>\n");
    }

    public void setParent(Tag tag) {
        this.parentTag = tag;
    }

    public Tag getParent() {
        return this.parentTag;
    }

    public int doStartTag() throws JspTagException {
        ColumnTag ancestorTag = (ColumnTag)TagSupport.findAncestorWithClass((Tag)this, ColumnTag.class);
        if (ancestorTag == null) {
            throw new JspTagException("A " + this.getTagName() + " tag must be used within a ColumnTag.");
        }
        ancestorTag.setDecorator((ColumnDecorator)this);
        return 0;
    }

    public int doEndTag() {
        return 6;
    }

    public void release() {
        this.setParent(null);
        this.setPageContext(null);
    }

    protected abstract String getTagName();

    protected Object evalAttr(String name, String value, Class<?> type) throws JspException {
        return ExpressionUtil.evalNotNull((String)this.getTagName(), (String)name, (String)value, type, (Tag)this, (PageContext)this.getPageContext());
    }

    protected abstract boolean isMonitorSupported();

    protected abstract boolean isEventsSupported();

    protected abstract boolean isInventorySupported();

    protected abstract boolean isConfigureSupported();

    protected abstract boolean isOperationsSupported();

    protected abstract boolean isAlertSupported();

    protected abstract boolean isContentSupported();

    protected abstract boolean isMonitorAllowed();

    protected abstract boolean isEventsAllowed();

    protected abstract boolean isInventoryAllowed();

    protected abstract boolean isConfigureAllowed();

    protected abstract boolean isOperationsAllowed();

    protected abstract boolean isAlertAllowed();

    protected abstract boolean isContentAllowed();

    protected abstract String getMonitorURL();

    protected abstract String getEventsURL();

    protected abstract String getInventoryURL();

    protected abstract String getConfigureURL();

    protected abstract String getOperationsURL();

    protected abstract String getAlertURL();

    protected abstract String getContentURL();
}

