/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.measurement.graphs;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;
import org.rhq.core.clientapi.util.units.UnitsFormat;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.common.EntityContext;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityPoint;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailabilityUIBean {
    private final Log log = LogFactory.getLog(AvailabilityUIBean.class);
    private AvailabilityManagerLocal availabilityManager = LookupUtil.getAvailabilityManager();
    private List<AvailabilityPoint> data = null;
    private String percentage = "???";

    public List<AvailabilityPoint> getData() {
        return this.data;
    }

    public String getPercentage() {
        return this.percentage;
    }

    public AvailabilityUIBean() {
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        EntityContext context = WebUtility.getEntityContext();
        try {
            MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
            long adjust = (rangePreferences.end - rangePreferences.begin) / 60L;
            if (context.category == EntityContext.Category.Resource) {
                this.data = this.availabilityManager.findAvailabilitiesForResource(user.getSubject(), context.resourceId, rangePreferences.begin - adjust, rangePreferences.end - adjust, 60, !rangePreferences.readOnly);
            } else if (context.category == EntityContext.Category.ResourceGroup) {
                this.data = this.availabilityManager.findAvailabilitiesForResourceGroup(user.getSubject(), context.groupId, rangePreferences.begin - adjust, rangePreferences.end - adjust, 60, !rangePreferences.readOnly);
            } else if (context.category == EntityContext.Category.AutoGroup) {
                this.data = this.availabilityManager.findAvailabilitiesForAutoGroup(user.getSubject(), context.parentResourceId, context.resourceTypeId, rangePreferences.begin - adjust, rangePreferences.end - adjust, 60, !rangePreferences.readOnly);
            }
            if (this.data != null) {
                this.percentage = this.getFormattedAvailability(this.data);
            }
        }
        catch (Exception e) {
            this.log.info((Object)("Error while looking up availability data for " + context));
        }
    }

    protected String getFormattedAvailability(List<AvailabilityPoint> values) {
        double sum = 0.0;
        int count = 0;
        for (AvailabilityPoint ap : values) {
            if (!ap.isKnown()) continue;
            ++count;
            if (ap.getAvailabilityType() != AvailabilityType.UP) continue;
            sum += 1.0;
        }
        double result = sum == 0.0 ? 0.0 : sum / (double)count;
        UnitNumber average = new UnitNumber(result, UnitsConstants.UNIT_PERCENTAGE);
        return UnitsFormat.format((UnitNumber)average).toString();
    }
}

