/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceTypeTemplateCountComposite;
import org.rhq.enterprise.gui.legacy.Portal;
import org.rhq.enterprise.gui.legacy.action.BaseDispatchAction;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditDefaultsAction
extends BaseDispatchAction {
    ResourceTypeManagerLocal typeMgr = LookupUtil.getResourceTypeManager();
    Map<Integer, ResourceTypeTemplateCountComposite> compositeMap;

    public ActionForward getMonitorDefaults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse resp) throws Exception {
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        String viewMode = WebUtility.getOptionalRequestParameter((ServletRequest)request, (String)"viewMode", null);
        List platformTypes = null;
        List serverTypes = null;
        if ("existing".equals(viewMode)) {
            platformTypes = this.typeMgr.getUtilizedResourceTypesByCategory(subject, ResourceCategory.PLATFORM, null);
            serverTypes = this.typeMgr.getUtilizedResourceTypesByCategory(subject, ResourceCategory.SERVER, null);
        } else {
            platformTypes = this.typeMgr.getAllResourceTypesByCategory(subject, ResourceCategory.PLATFORM);
            serverTypes = this.typeMgr.getAllResourceTypesByCategory(subject, ResourceCategory.SERVER);
        }
        Map platformServices = new HashMap();
        if (platformTypes.size() > 0) {
            for (ResourceType platformTypeEntry : platformTypes) {
                platformServices = this.typeMgr.getChildResourceTypesForResourceTypes(Arrays.asList(platformTypeEntry));
                if (platformServices.size() <= 0) continue;
                break;
            }
        }
        Map services = this.typeMgr.getChildResourceTypesForResourceTypes(serverTypes);
        this.initCompositeMap();
        request.setAttribute("platformTypes", (Object)this.convertToComposite(platformTypes));
        request.setAttribute("PlatformServices", (Object)this.convertToComposite(platformServices));
        request.setAttribute("serverTypes", (Object)this.convertToComposite(serverTypes));
        request.setAttribute("Services", (Object)this.convertToComposite(services));
        request.setAttribute("viewMode", (Object)viewMode);
        Portal p = Portal.createPortal((String)"admin.home.ResourceTemplates", (String)".admin.config.EditMonitorConfig");
        request.setAttribute("portal", (Object)p);
        return null;
    }

    protected Properties getKeyMethodMap() {
        Properties map = new Properties();
        map.setProperty("monitor", "getMonitorDefaults");
        return map;
    }

    private List<ResourceTypeTemplateCountComposite> convertToComposite(List<ResourceType> intermediates) {
        ArrayList<ResourceTypeTemplateCountComposite> results = new ArrayList<ResourceTypeTemplateCountComposite>();
        for (ResourceType next : intermediates) {
            results.add((ResourceTypeTemplateCountComposite)this.compositeMap.get(next.getId()));
        }
        return results;
    }

    private Map<Integer, SortedSet<ResourceTypeTemplateCountComposite>> convertToComposite(Map<Integer, SortedSet<ResourceType>> intermediates) {
        HashMap<Integer, SortedSet<ResourceTypeTemplateCountComposite>> results = new HashMap<Integer, SortedSet<ResourceTypeTemplateCountComposite>>();
        for (Integer key : intermediates.keySet()) {
            TreeSet composites = new TreeSet();
            results.put(key, composites);
            SortedSet<ResourceType> types = intermediates.get(key);
            for (ResourceType next : types) {
                composites.add(this.compositeMap.get(next.getId()));
            }
        }
        return results;
    }

    private void initCompositeMap() {
        this.compositeMap = this.typeMgr.getTemplateCountCompositeMap();
        List duplicateTypeNames = this.typeMgr.getDuplicateTypeNames();
        for (ResourceTypeTemplateCountComposite composite : this.compositeMap.values()) {
            if (!duplicateTypeNames.contains(composite.getType().getName())) continue;
            composite.setPluginInfo("(" + composite.getType().getPlugin() + " Plugin)");
        }
    }
}

