/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.role;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.admin.role.RemoveForm;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RemoveAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)RemoveAction.class.getName());
        RemoveForm rmForm = (RemoveForm)form;
        ActionForward forward = this.checkSubmit(request, mapping, form);
        if (forward != null) {
            return forward;
        }
        Integer[] roles = rmForm.getRoles();
        if (roles == null || roles.length < 1) {
            log.trace((Object)"no roles specified in request");
            return this.returnFailure(request, mapping);
        }
        Subject whoami = RequestUtils.getSubject((HttpServletRequest)request);
        for (int i = 0; i < roles.length; ++i) {
            log.trace((Object)("removing role [" + roles[i] + "]"));
        }
        try {
            RoleManagerLocal roleManager = LookupUtil.getRoleManager();
            roleManager.deleteRoles(whoami, roles);
        }
        catch (Exception e) {
            log.trace((Object)"failed to remove roles");
            RequestUtils.setError((HttpServletRequest)request, (String)"admin.role.error.RemoveRolePermission");
            return this.returnFailure(request, mapping);
        }
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"admin.role.confirm.Remove");
        return this.returnSuccess(request, mapping);
    }
}

