/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.role;

import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.util.AuthzConstants;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.admin.role.RemoveResourceGroupsForm;
import org.rhq.enterprise.gui.admin.role.RemoveUsersForm;
import org.rhq.enterprise.gui.legacy.action.WorkflowPrepareAction;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ViewAction
extends WorkflowPrepareAction {
    LdapGroupManagerLocal ldapManager = LookupUtil.getLdapGroupManager();
    RoleManagerLocal roleManager = LookupUtil.getRoleManager();
    ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();

    public ActionForward workflow(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)ViewAction.class.getName());
        Integer roleId = RequestUtils.getRoleId((HttpServletRequest)request);
        Role role = (Role)request.getAttribute("Role");
        if (role == null) {
            RequestUtils.setError((HttpServletRequest)request, (String)"admin.role.error.RoleNotFound");
            return null;
        }
        Subject whoami = RequestUtils.getSubject((HttpServletRequest)request);
        PageControl pcu = WebUtility.getPageControl((ServletRequest)request, (String)"u");
        PageControl pcg = WebUtility.getPageControl((ServletRequest)request, (String)"g");
        PageControl pcldap = WebUtility.getPageControl((ServletRequest)request, (String)"l");
        log.trace((Object)("user page control: " + pcu));
        log.trace((Object)("group page control: " + pcg));
        log.trace((Object)("ldap group page control: " + pcldap));
        Set permissions = this.roleManager.getPermissions(roleId);
        HashMap<String, Boolean> permission_map = new HashMap<String, Boolean>();
        for (Permission p : permissions) {
            permission_map.put(p.name(), Boolean.TRUE);
        }
        request.setAttribute("rolePermissions", permission_map);
        log.trace((Object)("getting users for role [" + roleId + "]"));
        PageList users = this.roleManager.findSubjectsByRole(roleId, pcu);
        request.setAttribute("RoleUsers", (Object)users);
        log.trace((Object)("getting resource groups for role [" + roleId + "]"));
        PageList groups = this.groupManager.findResourceGroupsForRole(whoami, roleId.intValue(), pcg);
        request.setAttribute("RoleResGrps", (Object)groups);
        if (groups == null) {
            request.setAttribute("NumResGrps", (Object)new Integer(0));
        } else {
            request.setAttribute("NumResGrps", (Object)new Integer(groups.getTotalSize()));
        }
        PageList ldapGroups = this.ldapManager.findLdapGroupsByRole(roleId.intValue(), pcldap);
        request.setAttribute("RoleLdapGrps", (Object)ldapGroups);
        if (ldapGroups == null) {
            request.setAttribute("NumLdapGrps", (Object)new Integer(0));
        } else {
            request.setAttribute("NumLdapGrps", (Object)new Integer(ldapGroups.getTotalSize()));
        }
        RemoveUsersForm rmUsersForm = new RemoveUsersForm();
        rmUsersForm.setR(roleId);
        int psu = RequestUtils.getPageSize((HttpServletRequest)request, (String)"psu");
        rmUsersForm.setPs(new Integer(psu));
        request.setAttribute("RemoveRoleUsersForm", (Object)rmUsersForm);
        RemoveResourceGroupsForm rmGroupsForm = new RemoveResourceGroupsForm();
        rmGroupsForm.setR(roleId);
        int psg = RequestUtils.getPageSize((HttpServletRequest)request, (String)"psg");
        rmGroupsForm.setPs(new Integer(psg));
        request.setAttribute("RemoveRoleResourceGroupsForm", (Object)rmGroupsForm);
        if (AuthzConstants.authzResourceGroupId.intValue() == roleId.intValue()) {
            context.putAttribute("superUser", (Object)"true");
        }
        return null;
    }
}

