/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.metric;

import java.util.Calendar;
import java.util.Date;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;

public class AdvancedMetricSettingsUIBean {
    private static final String DURATION_TYPE = "duration";
    private static final String INTERVAL_TYPE = "interval";
    private int duration;
    private Integer unit;
    private String intervalType;
    private String durationType;
    private Date fromTime;
    private Date toTime;

    public AdvancedMetricSettingsUIBean() {
        this.init();
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public Integer getUnit() {
        return this.unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public void setIntervalType(String intervalType) {
        this.intervalType = intervalType;
    }

    public String getIntervalType() {
        return this.intervalType;
    }

    public void setDurationType(String durationType) {
        this.durationType = durationType;
    }

    public String getDurationType() {
        return this.durationType;
    }

    public Date getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(Date fromTime) {
        this.fromTime = fromTime;
    }

    public Date getToTime() {
        return this.toTime;
    }

    public void setToTime(Date toTime) {
        this.toTime = toTime;
    }

    public void execute() {
        FacesContext facesContext = FacesContextUtility.getFacesContext();
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        String metricType = "";
        metricType = this.getIntervalType() == null ? this.getDurationType() : this.getIntervalType();
        if (metricType == null || metricType.equals("")) {
            facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Range select error", "Please select one option to either setup the duration or the time interval"));
        } else if (metricType.equalsIgnoreCase(DURATION_TYPE)) {
            rangePreferences.readOnly = false;
            rangePreferences.lastN = this.duration;
            rangePreferences.unit = this.unit;
            facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Preferences updated", "Your preferences have been successfully updated"));
        } else if (metricType.equalsIgnoreCase(INTERVAL_TYPE)) {
            if (this.getFromTime() == null || this.getToTime() == null) {
                facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Range select error", "Please make sure to fill in the from and to dates"));
            } else {
                Long fromTime = this.getFromTime().getTime();
                Long toTime = this.getToTime().getTime();
                Long now = Calendar.getInstance().getTime().getTime();
                if (toTime == null || fromTime == null) {
                    facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Timing error", "Please fill in the required fields"));
                } else if (toTime < fromTime) {
                    facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Timing error", "To time cannot be earlier than before time"));
                } else if (toTime > now || fromTime > now) {
                    facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Timing error", "Cannot set time interval in the future"));
                } else {
                    rangePreferences.readOnly = true;
                    rangePreferences.begin = fromTime;
                    rangePreferences.end = toTime;
                }
                facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Preferences updated", "Your preferences have been successfully updated"));
            }
        }
        preferences.setMetricRangePreferences(rangePreferences);
    }

    public void init() {
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        if (rangePreferences.readOnly) {
            this.setDurationType(null);
            this.setIntervalType(INTERVAL_TYPE);
            this.setUnit(null);
            this.setFromTime(new Date(rangePreferences.begin));
            this.setToTime(new Date(rangePreferences.end));
        } else {
            this.setDurationType(DURATION_TYPE);
            this.setIntervalType(null);
            this.setDuration(rangePreferences.lastN);
            this.setUnit(Integer.valueOf(rangePreferences.unit));
            this.setFromTime(null);
            this.setToTime(null);
        }
    }
}

