/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.quicknav;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.core.gui.util.UrlUtility;
import org.rhq.enterprise.gui.common.quicknav.IconComponent;
import org.rhq.enterprise.gui.common.quicknav.QuickNavComponent;

public class IconRenderer
extends Renderer {
    private static final String QUICKNAV_CELL_STYLE_CLASS = "quicknav-cell";
    private static final String QUICKNAV_BLOCK_STYLE_CLASS = "quicknav-block";
    private static final String IMAGES_PATH = "/images";
    private static final String ICON_IMAGE_WIDTH = "16";
    private static final String ICON_IMAGE_HEIGHT = "16";

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        IconComponent icon = (IconComponent)component;
        this.processAttributes(icon);
        icon.setParameters(FacesComponentUtility.getParameters((UIComponent)icon));
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("td", (UIComponent)icon);
        writer.writeAttribute("class", (Object)QUICKNAV_CELL_STYLE_CLASS, null);
        writer.startElement("div", (UIComponent)icon);
        writer.writeAttribute("class", (Object)QUICKNAV_BLOCK_STYLE_CLASS, null);
        if (icon.isVisible().booleanValue()) {
            writer.startElement("a", (UIComponent)icon);
            writer.writeAttribute("href", (Object)this.buildURL(icon), "url");
            writer.startElement("img", (UIComponent)icon);
            String imageBasePath = "/images/icons/" + icon.getName();
            String imageURL = imageBasePath + "_grey_16.png";
            writer.writeAttribute("src", (Object)imageURL, null);
            writer.writeAttribute("alt", (Object)icon.getAlt(), "alt");
            writer.writeAttribute("title", (Object)icon.getAlt(), "alt");
            writer.writeAttribute("width", (Object)"16", null);
            writer.writeAttribute("height", (Object)"16", null);
            writer.writeAttribute("border", (Object)0, null);
            writer.endElement("img");
            writer.endElement("a");
        }
        writer.endElement("div");
        writer.endElement("td");
        writer.append((CharSequence)"\n");
    }

    private void processAttributes(IconComponent icon) {
        if (icon.getName() == null) {
            throw new IllegalStateException("The 'icon' element requires a 'name' attribute.");
        }
        if (icon.getUrl() == null) {
            throw new IllegalStateException("The 'icon' element requires a 'url' attribute.");
        }
        if (icon.getAlt() == null) {
            throw new IllegalStateException("The 'icon' element requires a 'alt' attribute.");
        }
    }

    private String buildURL(IconComponent icon) {
        String url = icon.getUrl();
        QuickNavComponent quickNav = (QuickNavComponent)icon.getParent();
        LinkedHashMap parameters = new LinkedHashMap(quickNav.getParameters());
        parameters.putAll(icon.getParameters());
        url = UrlUtility.addParametersToQueryString((String)url, parameters);
        url = FacesContext.getCurrentInstance().getExternalContext().encodeResourceURL(url);
        return url;
    }
}

