/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.tabbar;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.core.gui.util.UrlUtility;
import org.rhq.enterprise.gui.common.tabbar.SubtabComponent;
import org.rhq.enterprise.gui.common.tabbar.TabBarComponent;
import org.rhq.enterprise.gui.common.tabbar.TabComponent;

public class SubtabRenderer
extends Renderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        SubtabComponent subtab = (SubtabComponent)component;
        this.processAttributes(subtab);
        TabComponent parentTab = (TabComponent)subtab.getParent();
        if (!parentTab.isSelected()) {
            return;
        }
        subtab.setParameters(FacesComponentUtility.getParameters((UIComponent)subtab));
        StringWriter stringWriter = new StringWriter();
        ResponseWriter writer = facesContext.getResponseWriter().cloneWithWriter((Writer)stringWriter);
        writer.startElement("td", (UIComponent)subtab);
        writer.startElement("a", (UIComponent)subtab);
        writer.writeAttribute("style", (Object)"text-decoration: none;", null);
        writer.writeAttribute("href", (Object)this.buildURL(subtab), "url");
        writer.startElement("div", (UIComponent)subtab);
        if (!subtab.isSelected()) {
            writer.writeAttribute("class", (Object)"subtab-inactive subtab-common", null);
            writer.writeAttribute("onmouseover", (Object)"this.className='subtab-hover subtab-common'", null);
            writer.writeAttribute("onmouseout", (Object)"this.className='subtab-inactive subtab-common'", null);
        } else {
            writer.writeAttribute("class", (Object)"subtab-active subtab-common", null);
            writer.startElement("img", (UIComponent)subtab);
            writer.writeAttribute("src", (Object)"/images/icon_right_arrow.gif", null);
            writer.endElement("img");
            writer.write(" ");
        }
        if (subtab.getDisplayName() != null) {
            writer.write(subtab.getDisplayName().toLowerCase());
        } else {
            writer.write(subtab.getName().toLowerCase());
        }
        writer.endElement("div");
        writer.endElement("a");
        writer.endElement("td");
        subtab.setRendererOutput(stringWriter.toString());
        stringWriter.close();
    }

    private void processAttributes(SubtabComponent subtab) {
        if (subtab.getName() == null) {
            throw new IllegalStateException("The subtab element requires a 'name' attribute.");
        }
        if (subtab.getUrl() == null) {
            throw new IllegalStateException("The subtab element requires a 'url' attribute.");
        }
    }

    private String buildURL(SubtabComponent subtab) {
        String url = subtab.getUrl();
        TabBarComponent tabBar = (TabBarComponent)subtab.getParent().getParent();
        LinkedHashMap parameters = new LinkedHashMap(tabBar.getParameters());
        TabComponent tab = (TabComponent)subtab.getParent();
        parameters.putAll(tab.getParameters());
        parameters.putAll(subtab.getParameters());
        url = UrlUtility.addParametersToQueryString((String)url, parameters);
        url = FacesContext.getCurrentInstance().getExternalContext().encodeResourceURL(url);
        return url;
    }
}

