/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import java.util.List;
import javax.faces.component.UIData;
import javax.servlet.http.HttpServletRequest;
import org.ajax4jsf.model.KeepAlive;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.content.InstalledPackageHistory;
import org.rhq.core.domain.content.PackageInstallationStep;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@KeepAlive
public class ShowInstalledPackageHistoryUIBean {
    private InstalledPackageHistory history;
    private int selectedHistoryId;
    private List<PackageInstallationStep> installationSteps;
    private UIData stepsData;
    private PackageInstallationStep step;
    private final Log log = LogFactory.getLog(this.getClass());

    public InstalledPackageHistory getHistory() {
        if (this.history == null) {
            ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
            this.history = contentUIManager.getInstalledPackageHistory(this.getSelectedHistoryId());
        }
        return this.history;
    }

    public void setHistory(InstalledPackageHistory history) {
        this.history = history;
    }

    public PackageInstallationStep getStep() {
        if (this.step == null) {
            HttpServletRequest request = FacesContextUtility.getRequest();
            int stepId = Integer.parseInt(request.getParameter("stepId"));
            ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
            this.step = contentUIManager.getPackageInstallationStep(stepId);
        }
        return this.step;
    }

    public int getSelectedHistoryId() {
        if (this.selectedHistoryId == 0) {
            HttpServletRequest request = FacesContextUtility.getRequest();
            this.selectedHistoryId = Integer.parseInt(request.getParameter("selectedHistoryId"));
        }
        return this.selectedHistoryId;
    }

    public void setSelectedHistoryId(int selectedHistoryId) {
        this.selectedHistoryId = selectedHistoryId;
    }

    public List<PackageInstallationStep> getInstallationSteps() {
        if (this.installationSteps == null) {
            InstalledPackageHistory history = this.getHistory();
            if (history == null) {
                this.log.error((Object)"Trying to load steps for null history");
                return this.installationSteps;
            }
            ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
            this.installationSteps = contentUIManager.getPackageInstallationSteps(history.getId());
        }
        return this.installationSteps;
    }

    public void setInstallationSteps(List<PackageInstallationStep> installationSteps) {
        this.installationSteps = installationSteps;
    }

    public UIData getStepsData() {
        return this.stepsData;
    }

    public void setStepsData(UIData stepsData) {
        this.stepsData = stepsData;
    }
}

