/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.Iterator;
import org.rhq.enterprise.gui.image.chart.ChartGraphics;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.chart.VerticalChart;

public class LineChart
extends VerticalChart {
    private Color[] m_clrDataLines = VerticalChart.DEFAULT_COLORS;
    public boolean isCumulative = false;

    public LineChart() {
    }

    public LineChart(int charts) {
        super(charts);
    }

    public LineChart(int width, int height) {
        super(width, height);
    }

    public LineChart(int width, int height, int charts) {
        super(width, height, charts);
    }

    protected Rectangle draw(ChartGraphics g) {
        Rectangle result = super.draw(g);
        return result;
    }

    protected void paint(ChartGraphics g, Rectangle rect) {
        int yLabelEvtDot = rect.y + rect.height + 5 + this.lineWidth;
        Stroke origStroke = g.graphics.getStroke();
        BasicStroke stroke = new BasicStroke(2.0f);
        g.graphics.setStroke(stroke);
        Iterator iterLines = this.getDataSetIterator();
        int line = 0;
        while (iterLines.hasNext()) {
            DataPointCollection collDataPoints = (DataPointCollection)iterLines.next();
            int cActualPts = 0;
            int cDataPts = collDataPoints.size();
            int[] aiX = new int[cDataPts];
            int[] aiY = new int[cDataPts];
            int[] yDataPt = new int[cDataPts];
            for (int index = 0; index < cDataPts; ++index) {
                Point ptData = this.getDataPoint(rect, index, collDataPoints);
                if (ptData != null) {
                    aiX[cActualPts] = ptData.x;
                    aiY[cActualPts] = ptData.y;
                    yDataPt[index] = ptData.y;
                    ++cActualPts;
                    continue;
                }
                yDataPt[index] = yLabelEvtDot;
            }
            g.graphics.setColor(this.m_clrDataLines[line]);
            g.graphics.drawPolyline(aiX, aiY, cActualPts);
            ++line;
        }
        g.graphics.setStroke(origStroke);
    }

    public Color getDataLineColor(int index) {
        return this.m_clrDataLines[index];
    }

    public void setDataLineColor(int index, Color color) {
        this.m_clrDataLines[index] = color;
    }
}

