/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.gui.legacy.action.BaseDispatchAction;
import org.rhq.enterprise.gui.legacy.action.resource.ResourceController;
import org.rhq.enterprise.gui.legacy.exception.ParameterNotFoundException;
import org.rhq.enterprise.gui.legacy.util.ActionUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

public abstract class GroupController
extends BaseDispatchAction {
    protected final Log log = LogFactory.getLog(ResourceController.class);

    protected void setResourceGroup(HttpServletRequest request) throws Exception {
        this.setResourceGroup(request, false);
    }

    protected void setResourceGroup(HttpServletRequest request, boolean config) throws Exception {
        Integer groupId = null;
        try {
            try {
                groupId = RequestUtils.getGroupId((HttpServletRequest)request);
            }
            catch (ParameterNotFoundException e) {
                // empty catch block
            }
            Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
            ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
            ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
            this.log.trace((Object)("finding group [" + groupId + "]"));
            ResourceGroup group = groupManager.getResourceGroupById(subject, groupId.intValue(), null);
            GroupCategory category = group.getGroupCategory();
            this.log.trace((Object)("finding most recent modifier for resource [" + groupId + "]"));
            Subject modifier = group.getModifiedBy();
            boolean isControllable = LookupUtil.getOperationManager().isGroupOperationSupported(subject, group.getId());
            RequestUtils.setResourceGroup((HttpServletRequest)request, (ResourceGroup)group);
            request.setAttribute("ResourceModifier", (Object)modifier);
            request.setAttribute("TitleParam", (Object)group.getName());
            request.setAttribute("category", (Object)category.name());
            request.setAttribute("groupId", (Object)groupId);
            request.setAttribute("controlEnabledAttr", (Object)new Boolean(isControllable));
        }
        catch (ResourceGroupNotFoundException e) {
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.common.error.ResourceGroupNotFound");
        }
    }

    protected void fetchReturnPathParams(HttpServletRequest request, Map params) {
        String category;
        Integer groupId = RequestUtils.getGroupId((HttpServletRequest)request);
        GroupCategory gc = RequestUtils.getGroupCategory((HttpServletRequest)request);
        if (gc != null) {
            category = gc.name();
        } else {
            category = GroupCategory.COMPATIBLE.name();
            this.log.warn((Object)"fetchReturnPathParam: No category was given, assuming compatible");
        }
        params.put("groupId", groupId);
        params.put("category", category);
        try {
            params.put("ctype", WebUtility.getChildResourceTypeId((HttpServletRequest)request));
        }
        catch (ParameterNotFoundException pnfe) {
            // empty catch block
        }
        try {
            Integer autogrouptype = RequestUtils.getAutogroupResourceTypeId((HttpServletRequest)request);
            params.put("autogrouptype", autogrouptype);
        }
        catch (ParameterNotFoundException pnfe) {
            // empty catch block
        }
        String mode = request.getParameter("mode");
        params.put("mode", mode);
    }

    protected void setReturnPath(HttpServletRequest request, ActionMapping mapping, Map params) throws Exception {
        this.fetchReturnPathParams(request, params);
        String returnPath = ActionUtils.findReturnPath((ActionMapping)mapping, (Map)params);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("setting return path: " + returnPath));
        }
        SessionUtils.setReturnPath((HttpSession)request.getSession(), (String)returnPath);
    }

    protected void setReturnPath(HttpServletRequest request, ActionMapping mapping) throws Exception {
        this.setReturnPath(request, mapping, new HashMap());
    }

    protected void setNavMapLocation(HttpServletRequest request, ActionMapping mapping, String currLoc) throws Exception {
        HashMap<String, String> parms = new HashMap<String, String>();
        String mode = request.getParameter("mode");
        parms.put("mode", mode);
        String newUrl = ActionUtils.changeUrl((String)currLoc, parms);
        request.setAttribute("currResourceMode", (Object)new String(mode));
        request.setAttribute("currResourceType", (Object)new String(currLoc));
        request.setAttribute("currResourceUrl", (Object)newUrl);
    }
}

