/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.events;

import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.core.clientapi.util.TimeUtil;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.composite.EventComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.events.EventDetailsAction;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.common.EntityContext;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.util.LookupUtil;

public class EventDetailsAction
extends BaseAction {
    private static final int DETAIL_MAX_LEN = 100;
    private static final int MAX_EVENTS_PER_DOT = 30;
    Log log = LogFactory.getLog(EventDetailsAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            StringBuffer html;
            WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
            MeasurementPreferences preferences = user.getMeasurementPreferences();
            MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
            long begin = rangePreferences.begin;
            long end = rangePreferences.end;
            long interval = TimeUtil.getInterval((long)begin, (long)end, (int)60);
            begin = Long.parseLong(WebUtility.getOptionalRequestParameter((ServletRequest)request, (String)"begin", (String)"0"));
            int resourceId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"id", (int)-1);
            int groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
            int parent = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
            int type = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
            EventManagerLocal eventManager = LookupUtil.getEventManager();
            Subject subject = user.getSubject();
            EntityContext context = new EntityContext(Integer.valueOf(resourceId), Integer.valueOf(groupId), Integer.valueOf(parent), Integer.valueOf(type));
            PageList events = eventManager.findEventComposites(subject, context, begin, begin + interval, null, null, null, new PageControl(0, 30));
            MessageResources res = this.getResources(request);
            if (events.isEmpty()) {
                html = new StringBuffer(res.getMessage("resource.common.monitor.text.events.None"));
            } else {
                html = new StringBuffer("<ul class=\"boxy\">");
                for (EventComposite event : events) {
                    html.append("<li> ");
                    EventSeverity severity = event.getSeverity();
                    switch (1.$SwitchMap$org$rhq$core$domain$event$EventSeverity[severity.ordinal()]) {
                        case 1: {
                            html.append("<img src=\"/images/event_fatal.gif\"/>");
                            break;
                        }
                        case 2: {
                            html.append("<img src=\"/images/event_error.gif\"/>");
                            break;
                        }
                        case 3: {
                            html.append("<img src=\"/images/event_warn.gif\"/>");
                            break;
                        }
                        case 4: {
                            html.append("<img src=\"/images/event_info.gif\"/>");
                            break;
                        }
                        case 5: {
                            html.append("<img src=\"/images/event_debug.gif\"/>");
                        }
                    }
                    html.append(" ");
                    this.createLinkForResource(resourceId, groupId, parent, type, html, event, this.ridBadChars(event.getEventDetail()));
                    html.append("</li>");
                }
                html.append("</ul>");
                if (events.getTotalSize() > 30) {
                    EventComposite event = (EventComposite)events.get(events.size() - 1);
                    html.append("<p/>");
                    this.createLinkForResource(resourceId, groupId, parent, type, html, event, res.getMessage("resource.common.monitor.text.events.MoreEvents"));
                    html.append("<p/>");
                }
            }
            request.setAttribute("ajaxType", (Object)"element");
            request.setAttribute("ajaxId", (Object)"eventsSummary");
            request.setAttribute("ajaxHTML", (Object)html);
        }
        catch (Exception e) {
            this.log.error((Object)"Error getting AJAX-style event details", (Throwable)e);
        }
        return mapping.findForward("success");
    }

    private void createLinkForResource(int resourceId, int groupId, int parent, int type, StringBuffer html, EventComposite event, String text) {
        html.append("<a href=\"/rhq/resource/events/history.xhtml?eventId=");
        html.append(event.getEventId());
        if (resourceId > -1) {
            html.append("&amp;id=").append(event.getResourceId());
        } else if (groupId > -1) {
            html.append("&amp;groupId=").append(groupId);
        } else {
            html.append("&amp;parent=").append(parent).append("&amp;type=").append(type);
        }
        html.append("\">");
        if (text.contains("\n")) {
            text = text.substring(0, text.indexOf("\n"));
        }
        if (text.length() > 100) {
            text = text.substring(0, 99);
        }
        html.append(text);
        html.append("</a>");
        html.append(" ");
    }

    private String ridBadChars(String source) {
        int sourceLen = source.length();
        if (sourceLen == 0) {
            return source;
        }
        StringTokenizer st = new StringTokenizer(source);
        StringBuffer buffer = new StringBuffer();
        while (st.hasMoreElements()) {
            String tok = st.nextToken();
            if ((tok = tok.replaceAll("['\"]", " ")).indexOf(60) > -1) {
                tok = StringUtil.replace((String)tok, (String)"<", (String)"&lt;");
            }
            buffer.append(tok).append(" ");
        }
        return buffer.toString();
    }
}

