/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.resource.ResourceForm;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.AlertDefUtil;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.DefinitionForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.alert.AlertDefinitionException;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class EditDefinitionConditionsAction
extends BaseAction {
    private Log log = LogFactory.getLog(EditDefinitionConditionsAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Integer> params;
        block14: {
            DefinitionForm defForm = (DefinitionForm)form;
            params = new HashMap<String, Integer>();
            ResourceForm.FormContext context = defForm.getContext();
            params.put("ad", defForm.getAd());
            if (context == ResourceForm.FormContext.Type) {
                params.put("type", defForm.getType());
            } else if (context == ResourceForm.FormContext.Resource) {
                params.put("id", defForm.getId());
            } else if (context == ResourceForm.FormContext.Group) {
                params.put("groupId", defForm.getGroupId());
            } else {
                throw new IllegalArgumentException("Unsupported context: " + context);
            }
            ActionForward forward = this.checkSubmit(request, mapping, form, params);
            if (forward != null) {
                this.log.trace((Object)("returning " + forward));
                return forward;
            }
            Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
            AlertDefinition alertDef = AlertDefUtil.getAlertDefinition((HttpServletRequest)request);
            try {
                defForm.exportConditionsEnablement(alertDef, request, subject);
            }
            catch (Exception e) {
                this.log.debug((Object)"alert definition update failed:", (Throwable)e);
                RequestUtils.setError((HttpServletRequest)request, (String)"alert.config.edit.definition.error", (Object)e.getMessage(), (String)"global");
                return this.returnFailure(request, mapping, null);
            }
            try {
                if (context == ResourceForm.FormContext.Type) {
                    AlertTemplateManagerLocal alertTemplateManager = LookupUtil.getAlertTemplateManager();
                    alertTemplateManager.updateAlertTemplate(subject, alertDef, true);
                    break block14;
                }
                if (context == ResourceForm.FormContext.Resource) {
                    AlertDefinitionManagerLocal alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
                    alertDefinitionManager.updateAlertDefinition(subject, alertDef.getId(), alertDef, true);
                    break block14;
                }
                if (context == ResourceForm.FormContext.Group) {
                    GroupAlertDefinitionManagerLocal groupAlertDefinitionManager = LookupUtil.getGroupAlertDefinitionManager();
                    groupAlertDefinitionManager.updateGroupAlertDefinitions(subject, alertDef, true);
                    break block14;
                }
                throw new IllegalArgumentException("Unsupported context: " + context);
            }
            catch (AlertDefinitionException iade) {
                this.log.debug((Object)"alert definition update failed:", (Throwable)iade);
                RequestUtils.setError((HttpServletRequest)request, (String)"alert.config.edit.definition.error", (Object)iade.getMessage(), (String)"global");
                return this.returnFailure(request, mapping, null);
            }
        }
        return this.returnSuccess(request, mapping, params);
    }
}

