/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.composite.MeasurementScheduleComposite;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.common.EntityContext;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ConfigMetricsFormPrepareAction
extends TilesAction {
    private final Log log = LogFactory.getLog((String)ConfigMetricsFormPrepareAction.class.getName());

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.trace((Object)"Executing ConfigMetricsFormPrepareAction...");
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
        MeasurementDefinitionManagerLocal definitionManager = LookupUtil.getMeasurementDefinitionManager();
        ResourceTypeManagerLocal rtManager = LookupUtil.getResourceTypeManager();
        boolean configuringDefaultSchedules = false;
        int type = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
        int parent = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
        if (type > 0 && parent == -1) {
            configuringDefaultSchedules = true;
        }
        PageList measurementSchedules = null;
        PageControl pageControl = WebUtility.getPageControl((ServletRequest)request);
        int groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
        if (configuringDefaultSchedules || groupId > 0 || type > 0 && parent > 0) {
            pageControl.initDefaultOrderingField("md.name");
        } else {
            pageControl.initDefaultOrderingField("ms.definition.name");
        }
        pageControl.setPageSize(-1);
        if (configuringDefaultSchedules) {
            int resourceTypeId = type;
            this.log.debug((Object)("Obtaining default metric schedules for resource type " + resourceTypeId + "..."));
            List definitions = definitionManager.findMeasurementDefinitionsByResourceType(subject, resourceTypeId, null, null);
            ArrayList<MeasurementScheduleComposite> composites = new ArrayList<MeasurementScheduleComposite>();
            for (MeasurementDefinition definition : definitions) {
                composites.add(new MeasurementScheduleComposite(definition, Boolean.valueOf(definition.isDefaultOn()), definition.getDefaultInterval()));
            }
            measurementSchedules = new PageList(composites, definitions.size(), pageControl);
            request.setAttribute("monitorEnabledAttr", (Object)Boolean.FALSE);
            ResourceType rType = rtManager.getResourceTypeById(subject, resourceTypeId);
            request.setAttribute("ResourceType", (Object)rType);
        } else {
            int resourceId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"id", (int)-1);
            if (parent > 0 && type > 0) {
                request.setAttribute("monitorEnabledAttr", (Object)true);
                measurementSchedules = scheduleManager.getMeasurementScheduleCompositesByContext(subject, EntityContext.forAutoGroup((int)parent, (int)type), pageControl);
                request.setAttribute("type", (Object)type);
                request.setAttribute("parent", (Object)parent);
                ResourceManagerLocal resMgr = LookupUtil.getResourceManager();
                Resource parentRes = resMgr.getResourceById(subject, parent);
                request.setAttribute("parentName", (Object)parentRes.getName());
            } else if (resourceId > 0) {
                boolean monitoringConfigured = this.isMonitoringConfigured(resourceId);
                request.setAttribute("monitorEnabledAttr", (Object)monitoringConfigured);
                if (monitoringConfigured) {
                    this.log.debug((Object)("Obtaining metric schedules for resource " + resourceId + "..."));
                    measurementSchedules = scheduleManager.getMeasurementScheduleCompositesByContext(subject, EntityContext.forResource((int)resourceId), pageControl);
                }
            } else if (groupId > 0) {
                boolean monitoringConfigured = true;
                request.setAttribute("monitorEnabledAttr", (Object)true);
                if (monitoringConfigured) {
                    this.log.debug((Object)("Obtaining metric schedules for comp group " + groupId + "..."));
                    measurementSchedules = scheduleManager.getMeasurementScheduleCompositesByContext(subject, EntityContext.forGroup((int)groupId), pageControl);
                    request.setAttribute("groupId", (Object)groupId);
                }
                ResourceGroupManagerLocal resourceGroupManager = LookupUtil.getResourceGroupManager();
                String groupName = resourceGroupManager.getResourceGroupById(subject, groupId, GroupCategory.COMPATIBLE).getName();
                request.setAttribute("groupName", (Object)groupName);
            }
        }
        if (measurementSchedules == null) {
            measurementSchedules = new PageList(pageControl);
        }
        request.setAttribute("measurementSchedules", measurementSchedules);
        return null;
    }

    private boolean isMonitoringConfigured(int resourceId) {
        return true;
    }
}

