/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.group.inventory;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.BaseValidatorForm;
import org.rhq.enterprise.gui.legacy.action.resource.group.inventory.AddGroupResourcesForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupUpdateException;
import org.rhq.enterprise.server.util.LookupUtil;

public class AddGroupResourcesAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog(AddGroupResourcesAction.class);
        HttpSession session = request.getSession();
        AddGroupResourcesForm addForm = (AddGroupResourcesForm)form;
        Integer groupId = addForm.getGroupId();
        String category = addForm.getCategory();
        HashMap<String, Object> forwardParams = new HashMap<String, Object>(2);
        forwardParams.put("groupId", groupId);
        forwardParams.put("category", category);
        try {
            ActionForward forward = this.checkSubmit(request, mapping, form, forwardParams);
            if (forward != null) {
                BaseValidatorForm spiderForm = (BaseValidatorForm)form;
                if (spiderForm.isCancelClicked() || spiderForm.isResetClicked()) {
                    log.trace((Object)"removing pending/removed resources list");
                    SessionUtils.removeList((HttpSession)session, (String)"PendingSessionResources");
                } else if (spiderForm.isAddClicked()) {
                    log.trace((Object)"adding to pending resources list");
                    SessionUtils.addToList((HttpSession)session, (String)"PendingSessionResources", (String[])addForm.getAvailableResources());
                } else if (spiderForm.isRemoveClicked()) {
                    log.trace((Object)"removing from pending resources list");
                    SessionUtils.removeFromList((HttpSession)session, (String)"PendingSessionResources", (String[])addForm.getPendingResources());
                }
                return forward;
            }
            ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
            Subject user = RequestUtils.getSubject((HttpServletRequest)request);
            log.trace((Object)"getting pending resource list");
            List pendingResourceIdStrings = SessionUtils.getListAsListStr((HttpSession)request.getSession(), (String)"PendingSessionResources");
            if (pendingResourceIdStrings.size() == 0) {
                return this.returnSuccess(request, mapping, forwardParams);
            }
            int[] pendingResourceIds = new int[pendingResourceIdStrings.size()];
            for (int i = 0; i < pendingResourceIds.length; ++i) {
                pendingResourceIds[i] = Integer.parseInt((String)pendingResourceIdStrings.get(i));
            }
            groupManager.addResourcesToGroup(user, groupId.intValue(), pendingResourceIds);
            log.trace((Object)"removing pending user list");
            SessionUtils.removeList((HttpSession)session, (String)"PendingSessionResources");
            RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.group.inventory.confirm.AddResources");
            return this.returnSuccess(request, mapping, forwardParams);
        }
        catch (ResourceGroupUpdateException rgue) {
            log.debug((Object)"group update failed:", (Throwable)rgue);
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.group.inventory.error.GroupUpdateError", (String)rgue.getMessage());
            return this.returnFailure(request, mapping, forwardParams);
        }
    }
}

