/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.hub;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.resource.hub.GroupHubForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.resource.group.ResourceGroupDeleteException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

public class RemoveGroupAction
extends BaseAction {
    protected Log log = LogFactory.getLog(RemoveGroupAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GroupHubForm hubForm = (GroupHubForm)form;
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
        String[] resources = hubForm.getResources();
        int remaining = resources.length;
        String invalidGroupIds = "";
        String invalidIntegers = "";
        String errorGroupIds = "";
        for (String item : resources) {
            try {
                groupManager.deleteResourceGroup(subject, new Integer(item).intValue());
                --remaining;
            }
            catch (ResourceGroupNotFoundException e) {
                invalidGroupIds = this.add(invalidGroupIds, item);
            }
            catch (NumberFormatException nfe) {
                invalidIntegers = this.add(invalidIntegers, item);
            }
            catch (ResourceGroupDeleteException rgde) {
                errorGroupIds = this.add(errorGroupIds, item);
            }
        }
        if (remaining == 0) {
            RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.confirm.ResourceGroupsRemoved");
            return this.returnSuccess(request, mapping);
        }
        ActionErrors errors = new ActionErrors();
        if (invalidGroupIds.length() > 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("resource.common.error.InvalidGroupIds", (Object)invalidGroupIds));
        }
        if (invalidIntegers.length() > 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("resource.common.error.InvalidIntegers", (Object)invalidIntegers));
        }
        if (errorGroupIds.length() > 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("resource.common.error.ErrorGroupIds", (Object)errorGroupIds));
        }
        RequestUtils.setErrors((HttpServletRequest)request, (ActionErrors)errors);
        return this.returnFailure(request, mapping);
    }

    private String add(String base, String addition) {
        if (base.length() != 0) {
            base = base + ", ";
        }
        return base + "'" + addition + "'";
    }
}

