/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.hub;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.InventorySummary;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.legacy.Portal;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.resource.hub.HubForm;
import org.rhq.enterprise.gui.legacy.action.resource.hub.ResourceHubForm;
import org.rhq.enterprise.gui.legacy.action.resource.hub.ResourceHubPortalAction;
import org.rhq.enterprise.gui.legacy.taglib.display.StringUtil;
import org.rhq.enterprise.gui.legacy.util.HubUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SessionTimeoutException;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ResourceHubPortalAction
extends BaseAction {
    public static final int SELECTOR_GROUP_COMPAT = 1;
    public static final int SELECTOR_GROUP_ADHOC = 2;
    private static final String DEFAULT_RESOURCE_CATEGORY = ResourceCategory.PLATFORM.name();
    private static final String DEFAULT_RESOURCE_NAME = null;
    private static final String HIERARCHY_SEPARATOR = " > ";
    private static final String ALL_RESOURCE_TYPES = null;
    private static final String ALL_PLUGINS = null;
    protected Log log = LogFactory.getLog((String)ResourceHubPortalAction.class.getName());
    private MessageResources messages;
    private ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
    private static String CHARSET = "UTF-16";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.messages = this.getResources(request);
        ResourceHubForm hubForm = (ResourceHubForm)form;
        String searchExpression = hubForm.getKeywords();
        if (searchExpression != null && searchExpression.equals("Resource Name")) {
            searchExpression = null;
        }
        String category = hubForm.getResourceCategory();
        String subtab = "all";
        try {
            ResourceCategory.valueOf((String)category.toUpperCase());
            subtab = category.toLowerCase();
        }
        catch (Exception e) {
            subtab = "hub";
        }
        String url = "/rhq/inventory/browseResources.xhtml?subtab=" + subtab;
        if (searchExpression != null && !searchExpression.trim().equals("")) {
            url = url + "&search=name=" + searchExpression;
        }
        response.sendRedirect(url);
        PageControl pageControl = WebUtility.getPageControl((ServletRequest)request);
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        HttpSession session = request.getSession();
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        HubUtils.initView((HubForm)hubForm, (WebUser)user);
        String resourceName = this.getResourceName(request, hubForm);
        String resourceType = ALL_RESOURCE_TYPES;
        if (hubForm.getResourceType() != null && !hubForm.getResourceType().trim().equals("")) {
            resourceType = this.decode(hubForm.getResourceType());
        }
        if (hubForm.getResourceCategory() == null || hubForm.getResourceCategory().equals("")) {
            hubForm.setResourceCategory(DEFAULT_RESOURCE_CATEGORY);
        }
        ResourceCategory resourceCategory = ResourceCategory.valueOf((String)hubForm.getResourceCategory());
        String pluginName = ALL_PLUGINS;
        if (hubForm.getPlugin() != null && !hubForm.getPlugin().trim().equals("")) {
            pluginName = this.decode(hubForm.getPlugin());
        }
        PageList resources = LookupUtil.getResourceManager().findResourceComposites(subject, resourceCategory, resourceType, pluginName, null, hubForm.getKeywords(), true, pageControl);
        request.setAttribute("AllResources", (Object)resources);
        this.initResourceTypesAndPluginsPulldownMenu(hubForm, subject, resourceCategory, resourceName, resourceType, pluginName);
        request.setAttribute("AllResourcesControllable", new ArrayList());
        this.initInventorySummary(subject, request);
        SessionUtils.resetReturnPath((HttpSession)request.getSession());
        request.setAttribute("portal", (Object)Portal.createPortal((String)"resource.hub.ResourceHubTitle", (String)".resource.hub"));
        String navHierarchy = this.buildResourceNavHierarchy(resourceCategory, resourceType);
        request.setAttribute("navHierarchy", (Object)navHierarchy);
        return this.returnSuccess(request, mapping);
    }

    private String buildResourceNavHierarchy(ResourceCategory resourceCategory, String resourceTypeName) {
        String navHierarchy = StringUtil.toUpperCaseAt((String)resourceCategory.toString(), (int)0) + "s" + HIERARCHY_SEPARATOR;
        navHierarchy = resourceTypeName != null ? navHierarchy + resourceTypeName : navHierarchy + "All " + StringUtil.toUpperCaseAt((String)resourceCategory.toString(), (int)0) + "s";
        return navHierarchy;
    }

    private void initInventorySummary(Subject user, HttpServletRequest request) throws SessionNotFoundException, SessionTimeoutException, RemoteException {
        InventorySummary summary = LookupUtil.getResourceBoss().getInventorySummary(user);
        request.setAttribute("ResourceSummary", (Object)summary);
    }

    private String getResourceName(HttpServletRequest request, ResourceHubForm hubForm) {
        String jsInserted = this.messages.getMessage("resource.hub.search.KeywordSearchText");
        String resourceName = hubForm.getKeywords();
        if (resourceName != null && (resourceName.equals("") || resourceName.equals(jsInserted))) {
            resourceName = DEFAULT_RESOURCE_NAME;
            hubForm.setKeywords(resourceName);
        }
        return resourceName;
    }

    protected void initResourceTypesAndPluginsPulldownMenu(ResourceHubForm hubForm, Subject subject, ResourceCategory resourceCategory, String nameFilter, String typeName, String pluginName) throws Exception {
        hubForm.addType(this.buildResourceTypeMenuCategoryLabel(resourceCategory));
        List resourceTypeNames = this.resourceTypeManager.getUtilizedResourceTypeNamesByCategory(subject, resourceCategory, nameFilter, pluginName);
        for (String resourceTypeName : resourceTypeNames) {
            hubForm.addType(new LabelValueBean(resourceTypeName, this.encode(resourceTypeName)));
        }
        hubForm.addPlugin(new LabelValueBean(this.messages.getMessage("resource.hub.filter.AllPlugins"), ""));
        List plugins = LookupUtil.getResourceMetadataManager().getPluginsByResourceTypeAndCategory(typeName, resourceCategory);
        for (Plugin plugin : plugins) {
            hubForm.addPlugin(new LabelValueBean(plugin.getDisplayName(), this.encode(plugin.getName())));
        }
    }

    protected LabelValueBean buildResourceTypeMenuCategoryLabel(@NotNull ResourceCategory resourceCategory) {
        String key = null;
        switch (1.$SwitchMap$org$rhq$core$domain$resource$ResourceCategory[resourceCategory.ordinal()]) {
            case 1: {
                key = "resource.hub.filter.AllPlatformTypes";
                break;
            }
            case 2: {
                key = "resource.hub.filter.AllServerTypes";
                break;
            }
            case 3: {
                key = "resource.hub.filter.AllServiceTypes";
            }
        }
        LabelValueBean menuLabel = new LabelValueBean(this.messages.getMessage(key), "");
        return menuLabel;
    }

    private String encode(String parameter) {
        return parameter.replaceAll(" ", "_");
    }

    private String decode(String parameter) {
        return parameter.replaceAll("_", " ");
    }
}

