/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.portlet.problemresources;

import java.util.List;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.composite.ProblemResourceComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.common.tag.FunctionTagLibrary;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.portlet.BaseRSSAction;
import org.rhq.enterprise.gui.legacy.portlet.RSSFeed;
import org.rhq.enterprise.server.measurement.MeasurementProblemManagerLocal;
import org.rhq.enterprise.server.measurement.util.MeasurementUtils;
import org.rhq.enterprise.server.util.LookupUtil;

public class RSSAction
extends BaseRSSAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RSSFeed feed = this.getNewRSSFeed(request);
        MessageResources res = this.getResources(request);
        feed.setTitle(res.getMessage("dash.home.ProblemResources"));
        WebUser user = this.getWebUser(request);
        if (user != null) {
            MeasurementProblemManagerLocal problemManager;
            PageList results;
            WebUserPreferences.ProblemResourcesPortletPreferences preferences = user.getWebPreferences().getProblemResourcesPortletPreferences();
            long begin = 0L;
            if (preferences.hours > 0) {
                List bounds = MeasurementUtils.calculateTimeFrame((int)preferences.hours, (int)3);
                begin = (Long)bounds.get(0);
            }
            if ((results = (problemManager = LookupUtil.getMeasurementProblemManager()).findProblemResources(user.getSubject(), begin, new PageControl(0, preferences.range))) != null && results.size() > 0) {
                for (ProblemResourceComposite problem : results) {
                    String link = feed.getBaseUrl() + FunctionTagLibrary.getDefaultResourceTabURL() + "?id=" + problem.getResourceId();
                    String availText = "";
                    if (problem.getAvailabilityType() != null) {
                        if (problem.getAvailabilityType() == AvailabilityType.DOWN) {
                            availText = res.getMessage("dash.home.ProblemResources.rss.item.downAvail");
                        } else if (problem.getAvailabilityType() == AvailabilityType.UP) {
                            availText = res.getMessage("dash.home.ProblemResources.rss.item.upAvail");
                        } else {
                            throw new IllegalStateException("invalid availability type - please report this bug");
                        }
                    }
                    feed.addItem(problem.getResourceName(), link, res.getMessage("dash.home.ProblemResources.rss.item.description", (Object)availText, (Object)problem.getNumAlerts()), System.currentTimeMillis());
                }
            }
            request.setAttribute("rssFeed", (Object)feed);
            return mapping.findForward("rss.feed");
        }
        throw new LoginException("RSS access requires authentication");
    }
}

