/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.portlet.resourcehealth;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.rhq.core.domain.resource.composite.DisambiguationReport;
import org.rhq.core.domain.resource.composite.ResourceHealthComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.gui.common.tag.FunctionTagLibrary;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.portlet.BaseRSSAction;
import org.rhq.enterprise.gui.legacy.portlet.RSSFeed;
import org.rhq.enterprise.gui.legacy.portlet.resourcehealth.ViewAction;
import org.rhq.enterprise.gui.legacy.taglib.display.DisambiguatedResourceLineageTag;
import org.rhq.enterprise.gui.legacy.util.DisambiguatedResourceListUtil;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class RSSAction
extends BaseRSSAction {
    private static final Log log = LogFactory.getLog((String)RSSAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RSSFeed feed = this.getNewRSSFeed(request);
        ResourceManagerLocal manager = LookupUtil.getResourceManager();
        MessageResources res = this.getResources(request);
        feed.setTitle(res.getMessage("dash.home.ResourceHealth"));
        WebUser user = this.getWebUser(request);
        if (user != null) {
            WebUserPreferences preferences = user.getWebPreferences();
            WebUserPreferences.FavoriteResourcePortletPreferences favoriteResourcePreferences = preferences.getFavoriteResourcePortletPreferences();
            PageList results = manager.findResourceHealth(user.getSubject(), favoriteResourcePreferences.asArray(), PageControl.getUnlimitedInstance());
            if (results != null && results.size() > 0) {
                PageList list = DisambiguatedResourceListUtil.disambiguate((ResourceManagerLocal)manager, (PageList)results, (IntExtractor)ViewAction.RESOURCE_ID_EXTRACTOR);
                for (DisambiguationReport summary : list) {
                    String link = feed.getBaseUrl() + FunctionTagLibrary.getDefaultResourceTabURL() + "?id=" + ((ResourceHealthComposite)summary.getOriginal()).getId();
                    String availText = res.getMessage("dash.home.ResourceHealth.rss.item.availability", (Object)((ResourceHealthComposite)summary.getOriginal()).getAvailabilityType().toString());
                    String alertsText = res.getMessage("dash.home.ResourceHealth.rss.item.alerts", (Object)((ResourceHealthComposite)summary.getOriginal()).getAlerts());
                    String typeText = res.getMessage("dash.home.ResourceHealth.rss.item.resourceType", (Object)((ResourceHealthComposite)summary.getOriginal()).getTypeName());
                    String parentsText = res.getMessage("dash.home.ResourceHealth.rss.item.resourceParents", (Object)RSSAction.getLineage((DisambiguationReport)summary));
                    long now = System.currentTimeMillis();
                    StringBuffer desc = new StringBuffer();
                    desc.append("<table><tr><td align=\"left\">").append(typeText).append("</td></tr>");
                    desc.append("<tr><td align=\"left\">").append(parentsText).append("</td></tr>");
                    if (favoriteResourcePreferences.showAvailability) {
                        desc.append("<tr><td align=\"left\">").append(availText).append("</td></tr>");
                    }
                    if (favoriteResourcePreferences.showAlerts) {
                        desc.append("<tr><td align=\"left\">").append(alertsText).append("</td></tr>");
                    }
                    desc.append("</table>");
                    feed.addItem(((ResourceHealthComposite)summary.getOriginal()).getName(), link, desc.toString(), now);
                }
            }
            request.setAttribute("rssFeed", (Object)feed);
            return mapping.findForward("rss.feed");
        }
        throw new LoginException("RSS access requires authentication");
    }

    private static String getLineage(DisambiguationReport<?> report) {
        StringWriter writer = new StringWriter();
        try {
            DisambiguatedResourceLineageTag.writeParents((Writer)writer, (List)report.getParents(), (boolean)false, (boolean)false);
            return writer.toString();
        }
        catch (IOException e) {
            return "";
        }
    }
}

