/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.measurement.graphs;

import java.util.ArrayList;
import java.util.List;
import org.rhq.core.clientapi.util.TimeUtil;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.beans.TimelineBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.common.EntityContext;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsTimelineUIBean {
    private EventManagerLocal eventManager = LookupUtil.getEventManager();
    private List<TimelineBean> data;
    private boolean showLogs = false;
    private EntityContext context;

    public List<TimelineBean> getData() {
        return this.data;
    }

    public boolean getShowLogs() {
        return this.showLogs;
    }

    public EntityContext getContext() {
        return this.context;
    }

    public EventsTimelineUIBean() {
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        long begin = rangePreferences.begin;
        long end = rangePreferences.end;
        int numberOfBuckets = 60;
        this.context = WebUtility.getEntityContext();
        EventSeverity[] eventsCounts = this.eventManager.getSeverityBucketsByContext(user.getSubject(), this.context, begin, end, numberOfBuckets);
        this.data = new ArrayList();
        long interval = TimeUtil.getInterval((long)begin, (long)end, (int)numberOfBuckets);
        for (int i = 0; i < numberOfBuckets; ++i) {
            TimelineBean bean = new TimelineBean(begin + interval * (long)i, eventsCounts[i]);
            this.data.add(bean);
        }
    }
}

