/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.authorization;

import java.util.Set;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class GlobalPermissionsUIBean {
    private boolean security;
    private boolean inventory;
    private boolean settings;
    private boolean bundle;
    private boolean isSuperuser;
    private boolean isDebugMode;
    private boolean isExperimental;

    public GlobalPermissionsUIBean() {
        Subject user = EnterpriseFacesContextUtility.getSubject();
        if (user.getId() != 0) {
            Set globalPermissions = LookupUtil.getAuthorizationManager().getExplicitGlobalPermissions(user);
            this.security = globalPermissions.contains(Permission.MANAGE_SECURITY);
            this.inventory = globalPermissions.contains(Permission.MANAGE_INVENTORY);
            this.settings = globalPermissions.contains(Permission.MANAGE_SETTINGS);
            this.bundle = globalPermissions.contains(Permission.MANAGE_BUNDLE);
            this.isSuperuser = LookupUtil.getAuthorizationManager().isSystemSuperuser(user);
        }
        SystemManagerLocal systemManager = LookupUtil.getSystemManager();
        this.isDebugMode = systemManager.isDebugModeEnabled();
        this.isExperimental = systemManager.isExperimentalFeaturesEnabled();
    }

    public boolean isSuperuser() {
        return this.isSuperuser;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public boolean isExperimental() {
        return this.isExperimental;
    }

    public boolean isSecurity() {
        return this.security;
    }

    public boolean isInventory() {
        return this.inventory;
    }

    public boolean isSettings() {
        return this.settings;
    }

    public boolean isBundle() {
        return this.bundle;
    }
}

