/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.framework;

import java.util.List;
import javax.faces.event.ActionEvent;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.SavedSearchCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.search.SavedSearch;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.search.SavedSearchManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class UserPreferencesUIBean {
    public static final String LEFT_RESOURCE_NAV_SHOWING = "ui.leftResourceNavShowing";
    public static final String SUMMARY_PANEL_DISPLAY_STATE = "ui.summaryPanelDisplayState";
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
    private SavedSearchManagerLocal savedSearchManager = LookupUtil.getSavedSearchManager();
    private List<Resource> resourceFavorites;
    private List<ResourceGroup> groupFavorites;
    private List<SavedSearch> savedSearches;
    private String refreshPath;
    private WebUser webUser;
    private Subject subject;

    public Subject getSubject() {
        if (this.subject == null) {
            this.loadUserInfo();
        }
        return this.subject;
    }

    public WebUser getWebUser() {
        if (this.webUser == null) {
            this.loadUserInfo();
        }
        return this.webUser;
    }

    private void loadUserInfo() {
        this.webUser = EnterpriseFacesContextUtility.getWebUser();
        this.subject = this.webUser.getSubject();
    }

    public String getLeftResourceNavState() {
        this.updateRecentVisits();
        return (String)EnterpriseFacesContextUtility.getWebUser().getWebPreferences().getPreference(LEFT_RESOURCE_NAV_SHOWING, (Object)"30");
    }

    public void setLeftResourceNavState(String state) {
        WebUserPreferences preferences = this.getWebUser().getWebPreferences();
        preferences.setPreference(LEFT_RESOURCE_NAV_SHOWING, (Object)state);
    }

    public void setRefreshPath(String path) {
        if (path != null && path.length() != 0) {
            this.refreshPath = path;
        }
    }

    public String getRefreshPath() {
        return this.refreshPath;
    }

    public void setPageRefresh(int refresh) {
        String path = this.refreshPath;
        if (path == null) {
            path = FacesContextUtility.getRequest().getParameter("originalPath");
        }
        if (path == null) {
            path = FacesContextUtility.getRequest().getRequestURI();
        }
        this.setPageRefresh(refresh, path);
    }

    public void setPageRefresh(int refresh, String path) {
        WebUserPreferences preferences = this.getWebUser().getWebPreferences();
        preferences.setPreference("PATH_REFRESH." + path, (Object)refresh);
    }

    public int getPageRefresh() {
        WebUserPreferences preferences = this.getWebUser().getWebPreferences();
        String path = (String)FacesContextUtility.getRequest().getAttribute("javax.servlet.forward.request_uri");
        if (path == null) {
            path = FacesContextUtility.getRequest().getParameter("originalPath");
        }
        if (path == null) {
            path = FacesContextUtility.getRequest().getRequestURI();
        }
        return (Integer)preferences.getPreference("PATH_REFRESH." + path, (Object)0);
    }

    public void updateSummaryPanelDisplayState(ActionEvent event) {
        String summaryPanelState = this.getSummaryPanelDisplayState();
        this.setSummaryPanelDisplayState(summaryPanelState.equals("true") ? "false" : "true");
    }

    public String getSummaryPanelDisplayState() {
        return (String)this.getWebUser().getWebPreferences().getPreference(SUMMARY_PANEL_DISPLAY_STATE, (Object)"true");
    }

    public void setSummaryPanelDisplayState(String state) {
        WebUserPreferences preferences = this.getWebUser().getWebPreferences();
        preferences.setPreference(SUMMARY_PANEL_DISPLAY_STATE, (Object)state);
    }

    public List<Resource> getResourceFavorites() {
        if (this.resourceFavorites == null) {
            WebUser user = EnterpriseFacesContextUtility.getWebUser();
            WebUserPreferences.FavoriteResourcePortletPreferences favoriteResources = user.getWebPreferences().getFavoriteResourcePortletPreferences();
            this.resourceFavorites = this.resourceManager.findResourceByIds(this.getSubject(), favoriteResources.asArray(), false, PageControl.getUnlimitedInstance());
        }
        return this.resourceFavorites;
    }

    public List<SavedSearch> getSavedSearches() {
        if (this.savedSearches == null) {
            SavedSearchCriteria criteria = new SavedSearchCriteria();
            criteria.addFilterSubjectId(Integer.valueOf(this.getSubject().getId()));
            criteria.addFilterGlobal(Boolean.valueOf(false));
            criteria.addSortName(PageOrdering.ASC);
            this.savedSearches = this.savedSearchManager.findSavedSearchesByCriteria(this.getSubject(), criteria);
        }
        return this.savedSearches;
    }

    public List<ResourceGroup> getGroupFavorites() {
        if (this.groupFavorites == null) {
            WebUser user = EnterpriseFacesContextUtility.getWebUser();
            WebUserPreferences.FavoriteGroupPortletPreferences favoriteGroups = user.getWebPreferences().getFavoriteGroupPortletPreferences();
            this.groupFavorites = this.groupManager.findResourceGroupByIds(this.getSubject(), favoriteGroups.asArray(), PageControl.getUnlimitedInstance());
        }
        return this.groupFavorites;
    }

    public List<WebUserPreferences.ResourceVisit> getRecentVisits() {
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        return user.getWebPreferences().getRecentResourceVisits();
    }

    public void updateRecentVisits() {
        String resourceId = FacesContextUtility.getOptionalRequestParameter((String)"id");
        String groupId = FacesContextUtility.getOptionalRequestParameter((String)"groupId");
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        WebUserPreferences prefs = user.getWebPreferences();
        WebUserPreferences.ResourceVisit visit = null;
        if (resourceId != null) {
            Resource res = this.resourceManager.getResourceById(this.getSubject(), Integer.parseInt(resourceId));
            visit = new WebUserPreferences.ResourceVisit(Integer.parseInt(resourceId), res.getName(), WebUserPreferences.ResourceVisit.Kind.valueOf((String)res.getResourceType().getCategory().name()));
        } else if (groupId != null) {
            ResourceGroup group = this.groupManager.getResourceGroupById(this.getSubject(), Integer.parseInt(groupId), null);
            visit = new WebUserPreferences.ResourceVisit(Integer.parseInt(groupId), group.getName(), group.getResourceType() != null ? WebUserPreferences.ResourceVisit.Kind.COMPATIBLE_GROUP : WebUserPreferences.ResourceVisit.Kind.MIXED_GROUP);
        }
        if (visit != null) {
            prefs.addRecentResource(visit);
        }
    }
}

