/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.servlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.gui.common.servlet.VerticalChartServlet;
import org.rhq.enterprise.gui.image.chart.Chart;
import org.rhq.enterprise.gui.image.chart.ColumnChart;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.chart.LineChart;
import org.rhq.enterprise.gui.image.chart.VerticalChart;
import org.rhq.enterprise.gui.legacy.beans.ChartDataBean;

public class MetricChartServlet
extends VerticalChartServlet {
    public static final String CHART_DATA_KEY_PARAM = "chartDataKey";
    public static final String SHOW_EVENTS_PARAM = "showEvents";
    private Log log = LogFactory.getLog((String)MetricChartServlet.class.getName());
    private String chartDataKey;
    private boolean plotLineChart;

    protected void parseParameters(HttpServletRequest request) {
        super.parseParameters(request);
        this.chartDataKey = this.parseRequiredStringParameter(request, CHART_DATA_KEY_PARAM);
        ChartDataBean dataBean = (ChartDataBean)request.getSession().getAttribute(this.chartDataKey);
        ArrayList dataPointsList = dataBean != null ? dataBean.getDataPoints() : new ArrayList();
        this.plotLineChart = dataPointsList.size() > 1;
    }

    protected Chart createChart() {
        if (this.plotLineChart) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"plotting a line chart");
            }
            return new LineChart(this.getImageWidth(), this.getImageHeight());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"plotting a column chart");
        }
        return new ColumnChart(this.getImageWidth(), this.getImageHeight());
    }

    protected void initializeChart(Chart chart) {
        super.initializeChart(chart);
        VerticalChart verticalChart = (VerticalChart)chart;
        verticalChart.showRightLabels = false;
        verticalChart.rightLabelWidth = (int)((double)this.getImageWidth() * 0.1);
        verticalChart.xLabelsSkip = 5;
    }

    protected void plotData(HttpServletRequest request, Chart chart) throws ServletException {
        VerticalChart veritcalChart = (VerticalChart)chart;
        ChartDataBean dataBean = (ChartDataBean)request.getSession().getAttribute(this.chartDataKey);
        ArrayList dataPointsList = dataBean != null ? dataBean.getDataPoints() : new ArrayList();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("got " + dataPointsList.size() + " set(s) of data points."));
        }
        veritcalChart.setNumberDataSets(dataPointsList.size());
        int i = 0;
        for (List data : dataPointsList) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("plotting " + data.size() + " data points"));
            }
            DataPointCollection chartData = chart.getDataPoints(i);
            chartData.addAll((Collection)data);
            ++i;
        }
        request.getSession().removeAttribute(this.chartDataKey);
    }

    protected boolean getDefaultShowPeak() {
        return true;
    }

    protected boolean getDefaultShowHighRange() {
        return true;
    }

    protected boolean getDefaultShowValues() {
        return true;
    }

    protected boolean getDefaultShowAverage() {
        return true;
    }

    protected boolean getDefaultShowLowRange() {
        return true;
    }

    protected boolean getDefaultShowLow() {
        return true;
    }

    protected boolean getDefaultShowBaseline() {
        return true;
    }

    protected boolean getDefaultShowEvents() {
        return true;
    }

    private void _logParameters() {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("Parameters:");
            sb.append("\n");
            sb.append("\t");
            sb.append(CHART_DATA_KEY_PARAM);
            sb.append(": ");
            sb.append(this.chartDataKey);
            sb.append("\n");
            sb.append("\t");
            this.log.debug((Object)sb.toString());
        }
    }
}

