/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.servlet;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.NumberUtil;

public abstract class ParameterizedServlet
extends HttpServlet {
    private Log log = LogFactory.getLog(ParameterizedServlet.class);

    protected boolean parseBooleanParameter(HttpServletRequest request, String paramName, boolean defaultValue) {
        boolean value = defaultValue;
        String param = request.getParameter(paramName);
        if (null != param) {
            value = Boolean.valueOf(param);
        }
        return value;
    }

    protected boolean parseRequiredBooleanParameter(HttpServletRequest request, String paramName) {
        String param = request.getParameter(paramName);
        if (null == param) {
            throw this.requiredParamErr(paramName);
        }
        boolean value = Boolean.valueOf(param);
        return value;
    }

    protected double parseDoubleParameter(HttpServletRequest request, String paramName, double defaultValue) {
        double value = defaultValue;
        String param = request.getParameter(paramName);
        if (null != param) {
            Number n = NumberUtil.stringAsNumber((String)param);
            if (n.equals(NumberUtil.NaN)) {
                this.invalidParamWarn(paramName, param, defaultValue);
            } else {
                value = n.doubleValue();
            }
        }
        return value;
    }

    protected double parseRequiredDoubleParameter(HttpServletRequest request, String paramName) {
        Number n;
        String param = request.getParameter(paramName);
        if (null != param) {
            n = NumberUtil.stringAsNumber((String)param);
            if (n.equals(NumberUtil.NaN)) {
                throw this.invalidParamErr(paramName, param);
            }
        } else {
            throw this.requiredParamErr(paramName);
        }
        double value = n.doubleValue();
        return value;
    }

    protected int parseIntParameter(HttpServletRequest request, String paramName, int defaultValue) {
        int value = defaultValue;
        String param = request.getParameter(paramName);
        if (null != param) {
            Number n = NumberUtil.stringAsNumber((String)param);
            if (n.equals(NumberUtil.NaN)) {
                this.invalidParamWarn(paramName, param, defaultValue);
            } else {
                value = n.intValue();
            }
        }
        return value;
    }

    protected int parseRequiredIntParameter(HttpServletRequest request, String paramName) {
        Number n;
        String param = request.getParameter(paramName);
        if (null != param) {
            n = NumberUtil.stringAsNumber((String)param);
            if (n.equals(NumberUtil.NaN)) {
                throw this.invalidParamErr(paramName, param);
            }
        } else {
            throw this.requiredParamErr(paramName);
        }
        int value = n.intValue();
        return value;
    }

    protected long parseLongParameter(HttpServletRequest request, String paramName, long defaultValue) {
        long value = defaultValue;
        String param = request.getParameter(paramName);
        if (null != param) {
            Number n = NumberUtil.stringAsNumber((String)param);
            if (n.equals(NumberUtil.NaN)) {
                this.invalidParamWarn(paramName, param, defaultValue);
            } else {
                value = n.longValue();
            }
        }
        return value;
    }

    protected long parseRequiredLongParameter(HttpServletRequest request, String paramName) {
        Number n;
        String param = request.getParameter(paramName);
        if (null != param) {
            n = NumberUtil.stringAsNumber((String)param);
            if (n.equals(NumberUtil.NaN)) {
                throw this.invalidParamErr(paramName, param);
            }
        } else {
            throw this.requiredParamErr(paramName);
        }
        long value = n.longValue();
        return value;
    }

    protected String parseStringParameter(HttpServletRequest request, String paramName, String defaultValue) {
        String value = request.getParameter(paramName);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    protected <E extends Enum<E>> E parseEnumParameter(HttpServletRequest request, String parameterName, Class<E> clazz, E defaultValue) {
        E value;
        String param = request.getParameter(parameterName);
        if (null == param) {
            return defaultValue;
        }
        try {
            value = Enum.valueOf(clazz, param);
        }
        catch (IllegalArgumentException iae) {
            value = defaultValue;
        }
        return value;
    }

    protected String parseStringParameter(HttpServletRequest request, String paramName, String defaultValue, String[] options) {
        String value = request.getParameter(paramName);
        if (null != value) {
            List<String> optionList = Arrays.asList(options);
            if (!optionList.contains(value)) {
                value = defaultValue;
                if (this.log.isWarnEnabled()) {
                    this.invalidParamWarn(paramName, value, defaultValue, optionList);
                }
            }
        } else {
            value = defaultValue;
        }
        return value;
    }

    protected String parseRequiredStringParameter(HttpServletRequest request, String paramName) {
        String value = request.getParameter(paramName);
        if (null == value) {
            throw this.requiredParamErr(paramName);
        }
        return value;
    }

    protected String parseRequiredStringParameter(HttpServletRequest request, String paramName, String[] options) {
        String value = request.getParameter(paramName);
        if (null != value) {
            List<String> optionList = Arrays.asList(options);
            if (!optionList.contains(value) && this.log.isWarnEnabled()) {
                this.invalidParamErr(paramName, value, optionList);
            }
        } else {
            throw this.requiredParamErr(paramName);
        }
        return value;
    }

    protected IllegalArgumentException requiredParamErr(String paramName) {
        String err = paramName + " is required.";
        return new IllegalArgumentException(err);
    }

    protected IllegalArgumentException invalidParamErr(String paramName, String param) {
        String err = "invalid " + paramName + ": " + param;
        return new IllegalArgumentException(err);
    }

    protected IllegalArgumentException invalidParamErr(String paramName, String param, List<String> optionList) {
        String err = "invalid " + paramName + ": " + param + ", must be one of: " + optionList;
        return new IllegalArgumentException(err);
    }

    protected void invalidParamWarn(String paramName, String param, double value) {
        this.invalidParamWarn(paramName, param, String.valueOf(value));
    }

    protected void invalidParamWarn(String paramName, String param, int value) {
        this.invalidParamWarn(paramName, param, String.valueOf(value));
    }

    protected void invalidParamWarn(String paramName, String param, long value) {
        this.invalidParamWarn(paramName, param, String.valueOf(value));
    }

    protected void invalidParamWarn(String paramName, String param, String value) {
        if (this.log.isWarnEnabled()) {
            String err = "invalid " + paramName + ": " + param + ", defaulting to: " + value;
            this.log.warn((Object)err);
        }
    }

    protected void invalidParamWarn(String paramName, String param, String value, List<String> optionList) {
        if (this.log.isWarnEnabled()) {
            String err = "invalid " + paramName + ": " + param + ", must be one of: " + optionList + ", defaulting to: " + value;
            this.log.warn((Object)err);
        }
    }
}

