/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.servlet;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.gui.common.servlet.ChartServlet;
import org.rhq.enterprise.gui.image.chart.Chart;
import org.rhq.enterprise.gui.image.chart.VerticalChart;

public abstract class VerticalChartServlet
extends ChartServlet {
    public static final String COLLECTION_TYPE_PARAM = "collectionType";
    private Log log = LogFactory.getLog((String)VerticalChartServlet.class.getName());
    private int collectionType;

    protected int getDefaultCollectionType() {
        return 0;
    }

    protected void parseParameters(HttpServletRequest request) {
        super.parseParameters(request);
        this.collectionType = this.parseIntParameter(request, COLLECTION_TYPE_PARAM, this.getDefaultCollectionType());
        this._logParameters();
    }

    protected void initializeChart(Chart chart) {
        super.initializeChart(chart);
        VerticalChart verticalChart = (VerticalChart)chart;
        int cumulativeTrend = this.getTrendForCollectionType(this.collectionType);
        verticalChart.setCumulativeTrend(cumulativeTrend);
    }

    protected int getTrendForCollectionType(int collectionType) {
        int trend = 0;
        switch (collectionType) {
            case 0: 
            case 1: {
                trend = 0;
                break;
            }
            case 2: {
                trend = 2;
                break;
            }
            case 3: {
                trend = 1;
                break;
            }
            default: {
                this.log.warn((Object)("Invalid collection type: " + collectionType));
            }
        }
        return trend;
    }

    private void _logParameters() {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("Parameters:");
            sb.append("\n");
            sb.append("\t");
            sb.append(COLLECTION_TYPE_PARAM);
            sb.append(": ");
            sb.append(this.collectionType);
            this.log.debug((Object)sb.toString());
        }
    }
}

