/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.tabbar;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.enterprise.gui.common.tabbar.SubtabComponent;
import org.rhq.enterprise.gui.common.tabbar.TabBarComponent;
import org.rhq.enterprise.gui.common.tabbar.TabComponent;

public class TabBarRenderer
extends Renderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        TabBarComponent tabBar = (TabBarComponent)component;
        this.processAttributes(tabBar);
        if (tabBar.getTabs().isEmpty()) {
            throw new IllegalStateException("The 'tabBar' element requires at least one 'tab' child element.");
        }
        tabBar.setParameters(FacesComponentUtility.getParameters((UIComponent)tabBar));
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", (UIComponent)tabBar);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("border-spacing", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.startElement("tr", (UIComponent)tabBar);
        this.writeCSSEdgeSpacerCell(writer, tabBar, true, false);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TabBarComponent tabBar = (TabBarComponent)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        this.writeCSSEdgeSpacerCell(writer, tabBar, false, false);
        writer.endElement("tr");
        this.writeSubTabs(writer, tabBar);
        writer.endElement("tr");
        writer.endElement("table");
    }

    private void processAttributes(TabBarComponent tabBar) {
        if (tabBar.getSelectedTabName() == null) {
            throw new IllegalStateException("The 'tabBar' element requires a 'selectedTabName' attribute.");
        }
        tabBar.selectTab(tabBar.getSelectedTabName());
    }

    private void writeSubTabs(ResponseWriter writer, TabBarComponent tabBar) throws IOException {
        writer.startElement("tr", (UIComponent)tabBar);
        writer.startElement("td", (UIComponent)tabBar);
        int tabs = 1;
        for (TabComponent tab : tabBar.getTabs()) {
            if (!tab.isRendered()) continue;
            ++tabs;
        }
        writer.writeAttribute("colspan", (Object)(tabs * 2), null);
        writer.startElement("table", (UIComponent)tabBar);
        writer.writeAttribute("class", (Object)"subtab-bar", null);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.startElement("tr", (UIComponent)tabBar);
        this.writeCSSEdgeSpacerCell(writer, tabBar, true, true);
        List subtabs = tabBar.getSelectedTab().getSubtabs();
        for (SubtabComponent subtab : subtabs) {
            if (subtab.getRendererOutput() == null) {
                throw new IllegalStateException("Subtabs for selected tab '" + tabBar.getSelectedTab().getName() + "' were not rendered - the tab is most likely not legitimate for the current Resource or Group.");
            }
            writer.write(subtab.getRendererOutput());
        }
        this.writeCSSEdgeSpacerCell(writer, tabBar, false, true);
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("td");
    }

    private void writeCSSEdgeSpacerCell(ResponseWriter writer, TabBarComponent tabBar, boolean isLeft, boolean isSub) throws IOException {
        writer.startElement("td", (UIComponent)tabBar);
        writer.writeAttribute("style", (Object)"vertical-align: bottom;", null);
        if (!isLeft) {
            writer.writeAttribute("width", (Object)"100%", null);
        }
        writer.startElement("div", (UIComponent)tabBar);
        String prefix = isSub ? "sub" : "";
        String styleClass = prefix + "tab-spacer";
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.write(".");
        writer.endElement("div");
        writer.endElement("td");
    }
}

