/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.tabbar;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.enterprise.gui.common.tabbar.AbstractTabComponent;
import org.rhq.enterprise.gui.common.tabbar.SubtabComponent;

public class TabComponent
extends AbstractTabComponent {
    public static final String COMPONENT_TYPE = "org.jboss.on.Tab";
    public static final String COMPONENT_FAMILY = "org.jboss.on.Tab";

    public String getFamily() {
        return "org.jboss.on.Tab";
    }

    @NotNull
    public List<SubtabComponent> getSubtabs() {
        ArrayList<SubtabComponent> subtabs = new ArrayList<SubtabComponent>();
        if (this.getChildCount() == 0) {
            return subtabs;
        }
        List children = this.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof SubtabComponent)) continue;
            subtabs.add((SubtabComponent)child);
        }
        return subtabs;
    }

    @Nullable
    public SubtabComponent getSubtabByName(String subtabName) {
        SubtabComponent selectedSubtab = null;
        for (SubtabComponent subtab : this.getSubtabs()) {
            if (!subtab.getName().equals(subtabName)) continue;
            selectedSubtab = subtab;
            break;
        }
        return selectedSubtab;
    }

    @Nullable
    public SubtabComponent getSelectedSubtab() {
        if (this.getSubtabs().isEmpty()) {
            return null;
        }
        List subtabs = this.getSubtabs();
        for (SubtabComponent subtab : subtabs) {
            if (!subtab.isSelected()) continue;
            return subtab;
        }
        if (this.isSelected()) {
            throw new IllegalStateException("'" + this.getName() + "' tab is selected and has subtabs, but no subtab is selected.");
        }
        return null;
    }

    @Nullable
    public SubtabComponent getDefaultSubtab() {
        if (this.getSubtabs().isEmpty()) {
            return null;
        }
        SubtabComponent subtab = this.isSelected() ? this.getSelectedSubtab() : (SubtabComponent)this.getSubtabs().get(0);
        return subtab;
    }
}

