/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.time.converter;

import java.text.DecimalFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

public class DurationConverter
implements Converter {
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final DecimalFormat twoDigitFormatter = new DecimalFormat("00");

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        long millis = 0L;
        if (value != null) {
            String[] parts = value.split(":");
            millis += (long)Integer.parseInt(parts[0]) * 3600000L;
            millis += (long)Integer.parseInt(parts[1]) * 60000L;
            millis += (long)Integer.parseInt(parts[2]) * 1000L;
        }
        return millis;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "00:00:00";
        }
        long millis = (Long)value;
        int hours = (int)(millis / 3600000L);
        int mins = (int)((millis %= 3600000L) / 60000L);
        int secs = (int)((millis %= 60000L) / 1000L);
        return this.format(hours) + ":" + this.format(mins) + ":" + this.format(secs);
    }

    private String format(int number) {
        return twoDigitFormatter.format(number);
    }
}

