/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration.test;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.gui.configuration.propset.ConfigurationSet;
import org.rhq.core.gui.configuration.propset.ConfigurationSetMember;
import org.rhq.enterprise.gui.configuration.test.TestConfigurationFactory;

public abstract class AbstractTestConfigurationUIBean {
    public static final String[] LABELS = new String[]{"AAA", "ZZZ", "BBB", "YYY", "AAA", "AAA", "ZZZ", "ZZZ", "YYY", "BBB"};
    public static final int GROUP_SIZE = 100;
    private ConfigurationDefinition configurationDefinition = TestConfigurationFactory.createConfigurationDefinition();
    private Configuration configuration = TestConfigurationFactory.createConfiguration();
    private List<Property> properties;
    private ConfigurationSet configurationSet;

    protected AbstractTestConfigurationUIBean() {
        ArrayList<ConfigurationSetMember> members = new ArrayList<ConfigurationSetMember>(100);
        for (int i = 0; i < 100; ++i) {
            Configuration configuration = this.configuration.deepCopy(true);
            configuration.setId(i + 1);
            configuration.getSimple("String1").setStringValue(UUID.randomUUID().toString());
            configuration.getSimple("Integer").setStringValue(String.valueOf(i + 1));
            configuration.getSimple("Boolean").setStringValue(String.valueOf(i % 2 == 0));
            if (i == 0) {
                configuration.getMap("OpenMapOfSimples").put((Property)new PropertySimple("PROCESSOR_CORES", (Object)"4"));
            }
            ConfigurationSetMember memberInfo = new ConfigurationSetMember(LABELS[100 % LABELS.length], configuration);
            members.add(memberInfo);
        }
        this.configurationSet = new ConfigurationSet(this.configurationDefinition, members);
        this.properties = new ArrayList(this.configuration.getProperties());
    }

    public String finish() {
        return "success";
    }

    @Nullable
    public ConfigurationDefinition getConfigurationDefinition() {
        return this.configurationDefinition;
    }

    public void setConfigurationDefinition(@NotNull ConfigurationDefinition configurationDefinition) {
        this.configurationDefinition = configurationDefinition;
    }

    @Nullable
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(@NotNull Configuration configuration) {
        this.configuration = configuration;
    }

    public ConfigurationSet getConfigurationSet() {
        return this.configurationSet;
    }

    public void setConfigurationSet(ConfigurationSet configurationSet) {
        this.configurationSet = configurationSet;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public String getNullConfigurationDefinitionMessage() {
        return "Test config def is null (should never happen).";
    }

    public String getNullConfigurationMessage() {
        return "Test config is null (should never happen).";
    }
}

