/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ContentSourceReposUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ContentSourceReposUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ContentSourceReposUIBean";

    public String deleteSelectedContentSourceRepos() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedContentSourceRepos();
        int contentSourceId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        int[] repoIds = this.getIntegerArray(selected);
        if (repoIds != null && repoIds.length > 0) {
            try {
                RepoManagerLocal manager = LookupUtil.getRepoManagerLocal();
                for (int repoId : repoIds) {
                    manager.removeContentSourcesFromRepo(subject, repoId, new int[]{contentSourceId});
                }
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Disassociated [" + repoIds.length + "] repositories from content source"));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to disassociate one or more repositories from content source", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ContentSourceReposDataModel(this, PageControlView.ContentSourceReposList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedContentSourceRepos() {
        return FacesContextUtility.getRequest().getParameterValues("selectedContentSourceRepos");
    }

    @NotNull
    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

